/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2019 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2019 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2021 GIMONS (Twitter:@kugimoto0715)
 *
 *	[ Win32API RtBM[V ]
 *
 *	RHG
 *	  2001.07.27		WCXeBbÑftHgݒuȂvɕύX
 *	  2001.12.26		TEhobt@̐ݒ͈͂40ms`2000msɕύX
 *	  2002.03.10		ݒI̍ĕ`挋ʂC
 *	  2002.04.05		FM48kHz/88.2kHz/96kHzݒɑΉ
 *	  2002.05.29		CPUx/TEhobt@TCY/BEEPg̒ڎw
 *						Ή
 *	  2002.06.15		@ύXꍇVMZbg悤ɕύX
 *	  2002.09.08		L[̓_CAOIME̓֎~悤ɏC
 *	  2002.09.09		INIt@C̃TCNX`[ݒ̕ϐ\L
 *						킹"CycleSteal"ɕύX
 *	  2002.09.12		t@CIftHgfBNg̕ۑɑΉ
 *	  2002.09.16		ݒy[WƂ̃y[W쐬֐p~
 *	  2002.10.21		fobOo[WRpCɑSʃy[W
 *						C
 *	  2002.12.09		V2߂Ń`lR[̐oȂC
 *	  2003.01.19		TEhobt@̃ftHgTCY100msɕύX
 *						F10Ɋ蓖ĂL[F11ւ̐Uւp~
 *	  2003.01.21		KeyboardZNVۑ܂Rb\ύX(
 *	  2003.03.09		t@CIftHgfBNg̎ޕʕۑɑΉ
 *	  2003.05.02		TuCPŨftHgsTCNύX
 *	  2003.06.03		CCPUETuCPŨftHgsTCN
 *	  2003.10.21		tXL[hEBhE[hƃtXN[
 *						[hŕʁXɐݒł悤ɂ
 *	  2004.03.17		^400C[h֘A̐ݒ荀ڂǉ
 *	  2004.10.06		400CJ[h֘A̐ݒ荀ڂǉ
 *	  2005.10.15		}EX[h؂ւ̐ݒ荀ڂǉ
 *	  2005.11.12		L[}bvݒFM-8ł̃L[̂ǉ
 *	  2010.01.23		ʒy[W
 *	  2010.04.24		N[h̕ۑɑΉ
 *	  2012.05.01		tXN[ԕۑւ̑Ή
 *	  2012.05.28		J[\L[ɂeL[G~[Ṽ`FbN
 *						ȂC
 *	  2012.06.03		Xe[^Xo[̕\Ԃ̕ۑɑΉ
 *	  2012.07.01		ou֘A̍ڂǉ
 *	  2012.08.01		tXN[̉ʊgɑΉ
 */

#ifdef _WIN32

#define STRICT
#define WIN32_LEAN_AND_MEAN
#define NONAMELESSUNION
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <prsht.h>
#ifdef DINPUT8
#define DIRECTINPUT_VERSION		0x0800		/* DirectX8w */
#else
#define DIRECTINPUT_VERSION		0x0300		/* DirectX3w */
#endif
#include <dinput.h>
#include <mmsystem.h>
#include <stdlib.h>
#include <assert.h>
#include "xm7.h"
#include "device.h"
#include "mainetc.h"
#include "subctrl.h"
#include "fdc.h"
#include "tapelp.h"
#include "opn.h"
#include "keyboard.h"
#include "mmr.h"
#include "mouse.h"
#include "aluline.h"
#include "display.h"
#include "kanji.h"
#include "jcard.h"
#include "jsubsys.h"
#include "rs232c.h"
#include "ttlpalet.h"
#include "bubble.h"
#include "w32.h"
#include "w32_bar.h"
#include "w32_cfg.h"
#include "w32_sch.h"
#include "w32_snd.h"
#include "w32_kbd.h"
#include "w32_dd.h"
#include "w32_draw.h"
#include "w32_gdi.h"
#include "w32_sub.h"
#include "w32_res.h"
#include "w32_comm.h"
#include "w32_midi.h"
#include "juliet.h"
#include "w32_lpr.h"


/*
 *	ݒf[^`
 */
typedef struct {
	int fm7_ver;						/* n[hEFAo[W */
	int boot_mode;						/* u[g[h */
	BOOL cycle_steal;					/* TCNX`[tO */
	BOOL subclock_mode;					/* TuCPU uLO^C~O */
	DWORD main_speed;					/* CCPUXs[h */
	DWORD mmr_speed;					/* CCPU(MMR)Xs[h */
#if XM7_VER >= 3
	DWORD fmmr_speed;					/* CCPU(MMR)Xs[h */
#endif
	DWORD sub_speed;					/* TuCPUXs[h */
	DWORD uTimerResolution;				/* }`fBA^C}[x */
	BOOL bTapeFull;						/* e[v[^̑xtO */
	BOOL bCPUFull;						/* S͋쓮tO */
	BOOL bSpeedAdjust;					/* x */
	BOOL bTapeMode;						/* e[v[^x^Cv */
#if XM7_VER == 1
	BYTE fm_subtype;					/* n[hEFATuo[W */
	BOOL lowspeed_mode;					/* CPUNbN[h */
	DWORD main_speed_low;				/* CCPUXs[h(ᑬ) */
	DWORD sub_speed_low;				/* TuCPUXs[h(ᑬ) */
#ifdef JSUB
	DWORD jsub_speed;					/* {TuCPUXs[h */
#endif
#endif

	int nSampleRate;					/* TvO[g */
	int nSoundBuffer;					/* TEhobt@TCY */
	int nBeepFreq;						/* BEEPg */
	BOOL bInterpolation;				/* TEhԏo */
	int uStereoOut;						/* o̓[h */
	BOOL bForceStereo;					/* XeIo */
	BOOL bTapeMon;						/* e[vj^ */
#ifdef ROMEO
	BOOL bUseRomeo;						/* ݂gptO */
#elif defined(SCCI)
	BOOL bUseSCCI;						/* SCCIgptO */
#endif
	UINT uChSeparation;					/* XeI`lZp[V */
	int nFMVolume;						/* FM{[ */
	int nPSGVolume;						/* PSG{[ */
	int nBeepVolume;					/* BEEP{[ */
	int nCMTVolume;						/* CMTj^{[ */
	int nWaveVolume;					/* eʉ{[ */

	BYTE KeyMap[256];					/* L[ϊe[u */
	BOOL bKbdReal;						/* [A^CL[XL */
	BOOL bTenCursor;					/* L[eL[ɑΉ */
	BOOL bArrow8Dir;					/* eL[ϊ 8[h */
	BOOL bAutoDetectKeyMap;				/* L[}bvݒtO */
#ifdef KBDPASTE
	UINT uPasteWait;					/* \t̕Pʑ҂(ms) */
	UINT uPasteWaitCntl;				/* \t̃Rg[R[hPʑ҂(ms) */
#endif

	int nJoyType[2];					/* WCXeBbN^Cv */
	int nJoyRapid[2][2];				/* WCXeBbNA */
	int nJoyCode[2][7];					/* WCXeBbNR[h */

	BYTE nDDResolutionMode;				/* tXN[̉𑜓x */
	BOOL bFullScan;						/* tXL(EBhE[h) */
	BOOL bFullScanFS;					/* tXL(tXN[) */
	BOOL bFullScreen;					/* tXN[[h */
	BOOL bDoubleSize;					/* 2{\tO */
	BOOL bDD480Status;					/* 640x480㉺Xe[^X */
	BOOL bDDtruecolor;					/* TrueColorDtO */
	BOOL bRasterRender;					/* X^_O */
	BOOL bDrawAfterVSYNC;				/* `VSYNC^C~O */
	BOOL bHideStatus;					/* Xe[^Xo[\ */
#if XM7_VER <= 2
	MONITORTYPE nMonitorType;			/* j^^Cv */
#endif
	BOOL bPseudo400Line;				/* ^400C[h */

	BOOL bOPNEnable;					/* OPNLtO(7 only) */
	BOOL bWHGEnable;					/* WHGLtO */
	BOOL bTHGEnable;					/* THGLtO */
#if XM7_VER == 1
	BOOL bPSGEnable;					/* PSGLtO(8 only) */
#endif
#if XM7_VER == 1
	BOOL bFMXEnable;					/* FM-X PSGLtO */
#endif
#if XM7_VER >= 2
	BOOL bDigitizeEnable;				/* fBW^CYLtO */
	BOOL bJCardEnable;					/* {J[hLtO */
#endif
#if ((XM7_VER >= 3) || (XM7_VER == 2 && defined(FMTV151)))
	BOOL bExtRAMEnable;					/* gRAMLtO */
	BYTE uExtRAMMode;					/* gRAM샂[h */
#endif
#if XM7_VER == 1
#ifdef L4CARD
	BOOL b400LineCardEnable;			/* 400CJ[hLtO */
	BYTE uExtRAMMode;					/* gRAM샂[h */
#endif
#ifdef JSUB
	BOOL bJSubEnable;					/* {TuVXeLtO */
#endif
#ifdef BUBBLE
	BOOL bBubbleEnable;					/* ouLtO */
#endif
	BYTE uBankSelectEnable;				/* oN؂芷Cl[utO */
	BOOL bPCGEnable;					/* PCGLtO */
	BOOL bSubSystemRomXchg;				/* TuVXeύXLtO */
	BOOL bKeyModeFlag;					/* FM-7݊L[̓[htO */
	BOOL bKeyIOPort;					/* CKeyI/OportCl[utO */
	BOOL bTTLPalet;						/* FM-7݊TTLpaletCl[utO */
	BOOL bFM7IRQ;						/* FM-7݊CIRQCl[utO */
#endif
#ifdef MOUSE
	BOOL bMouseCapture;					/* }EXLv`tO */
	BYTE nMousePort;					/* }EXڑ|[g */
	BYTE uMidBtnMode;					/* {^Ԏ擾[h */
#endif

#ifdef FDDSND
	BOOL bFddWait;						/* FDDEFCg */
	BOOL bFddSound;						/* FDDV[NTEh */
#endif

#ifdef RSC
	BOOL bCommPortEnable;				/* RS-232CG~[VLtO */
	BYTE uCommPortBps;					/* VA|[gʐMx */
	int nCommPortNo;					/* VA|[gԍ */
#endif

#ifdef MIDI
	char szMidiDevice[256];				/* MIDIfoCX */
	int nMidiDelay;						/* MIDIx */
	BOOL bMidiDelayMode;				/* MIDIxSoundBufferɍ킹 */
#endif

#ifdef LPRINT
	BYTE uPrinterEnable;				/* v^G~[V[h */
	BOOL bLprUseOsFont;					/* OS̃tHg𗘗p */
	BOOL bLprOutputKanji;				/* o͂ */
	char szLprLogPath[256+1];			/* v^Oo̓pX */
#endif

#if XM7_VER >= 2
	BOOL bLineBoost;					/* ԑS͕`tO */
#endif
#if XM7_VER >= 3
	BOOL b400LineTiming;				/* ??? */
	BOOL bSubModeFix;					/* FM77AVpOS-9΍tO */
#endif

	BOOL bPopupSwnd;					/* TuEBhE|bvAbv */
	BOOL bOFNCentering;					/* t@C_CAÕZ^O */
	BOOL bMagusPatch;					/* MAGUS΍􏈗 */
	BOOL bRomRamWrite;					/* FM-7[h̗RAMύX */
#if XM7_VER == 1
	BOOL bMotorOnLowSpeed;				/* CMT[^ONᑬ[h */
#endif
#if XM7_VER == 1
	BOOL bParityMode;					/* FM-8[hpeBtO */
#endif
#ifdef KBDPASTE
	BOOL bKeyStrokeModeless;			/* L[͎x_CAO[h */
#endif
} configdat_t;

/*
 *	X^eBbN [N
 */
static UINT uPropertyState;				/* vpeBV[gis */
static UINT uPropertyHelp;				/* wvID */
static UINT KbdPageSelectID;			/* L[{[h_CAO */
static UINT KbdPageCurrentKey;			/* L[{[h_CAO */
static BYTE KbdPageMap[256];			/* L[{[h_CAO */
static UINT JoyPageIdx;					/* WCXeBbNy[W */ 
static configdat_t configdat;			/* RtBOpf[^ */
static configdat_t propdat;				/* vpeBV[gpf[^ */
static char szIniFile[_MAX_PATH];		/* INIt@C */
static char *pszSection;				/* ZNV */
static char szMRUFile[MRU_TYPES][MRU_FILES][_MAX_PATH];	/* MRUt@C */
static int nMRUNum[MRU_TYPES];			/* MRU */
static BOOL bMRUMount[MRU_TYPES];		/* }EgtO */
static int nMRUMedia[MRU_TYPES][MRU_FILES];	/* fBAZNg */
static BOOL bMRUEject[MRU_TYPES];		/* ꎞCWFNg */
static BOOL bMRUWritep[MRU_TYPES];		/* CgveNg */
#if XM7_VER == 1
static BOOL bIsAmberMonitor;			/* j^^CvꎞL */
#endif

/*
 *	vg^Cv錾
 */
static void FASTCALL SheetInit(HWND hDlg);

/*
 *	RRg[ւ̃ANZX}N
 */
#define UpDown_GetPos(hwnd) \
	(DWORD)SendMessage((hwnd), UDM_GETPOS, 0, 0L)

#define UpDown_SetPos(hwnd, nPos) \
	SendMessage((hwnd), UDM_SETPOS, 0, MAKELPARAM(nPos, 0))

#define UpDown_SetRange(hwnd, nUpper, nLower) \
	SendMessage((hwnd), UDM_SETRANGE, 0, MAKELPARAM(nUpper, nLower))

/*
 *	pXۑpL[
 */
static const char *InitDirStr[] = {
	"DiskImageDir",
	"TapeImageDir",
	"StateFileDir",
	"BMPFileDir",
	"WAVFileDir",
#if XM7_VER == 1 && defined(BUBBLE)
	"BubbleImageDir",
#endif
#ifdef LPRINT
	"LptLogFileDir",
#endif
};

/*-[ ݒf[^ ]-----------------------------------------------------------*/

/*
 *	ݒf[^
 *	t@Cw
 */
static void FASTCALL SetCfgFile(void)
{
	char path[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];

	/* INIt@Cݒ */
	GetModuleFileName(NULL, path, sizeof(path));
	_splitpath(path, drive, dir, fname, NULL);
	strncpy(path, drive, sizeof(path));
	strncat(path, dir, sizeof(path) - strlen(path) - 1);
	strncat(path, fname, sizeof(path) - strlen(path) - 1);
	strncat(path, ".INI", sizeof(path) - strlen(path) - 1);

	strncpy(szIniFile, path, sizeof(szIniFile));
}

/*
 *	ݒf[^
 *	ZNVw
 */
static void FASTCALL SetCfgSection(char *section)
{
	ASSERT(section);

	/* ZNVݒ */
	pszSection = section;
}

/*
 *	ݒf[^
 *	[h()
 */
static BOOL LoadCfgString(char *key, char *buf, int length)
{
	ASSERT(key);

	GetPrivateProfileString(pszSection, key, ";", buf, length, szIniFile);

	if (buf[0] == ';') {
		return FALSE;
	}
	return TRUE;
}

/*
 *	ݒf[^
 *	[h(int)
 */
static int LoadCfgInt(char *key, int def)
{
	ASSERT(key);

	return (int)GetPrivateProfileInt(pszSection, key, def, szIniFile);
}

/*
 *	ݒf[^
 *	[h(BOOL)
 */
static BOOL FASTCALL LoadCfgBool(char *key, BOOL def)
{
	int dat;

	ASSERT(key);

	/* ǂݍ */
	if (def) {
		dat = LoadCfgInt(key, 1);
	}
	else {
		dat = LoadCfgInt(key, 0);
	}

	/* ] */
	if (dat != 0) {
		return TRUE;
	}
	else {
		return FALSE;
	}
}

/*
 *	ݒf[^
 *	[h(MRU)
 */
static void FASTCALL LoadCfgMRU(int type)
{
	int i;
	char string[256];

	ASSERT((type >= 0) && (type < MRU_TYPES));

	/* NA */
	for (i=0; i<MRU_FILES; i++) {
		memset(szMRUFile[type][i], 0, _MAX_PATH);
		nMRUMedia[type][i] = -1;
	}

	/* [v */
	nMRUNum[type] = 0;
	for (i=0; i<MRU_FILES; i++) {
		_snprintf(string, sizeof(string), "File%d", i);
		if (!LoadCfgString(string, szMRUFile[type][i], _MAX_PATH)) {
			szMRUFile[type][i][0] = '\0';
			break;
		}
		if (szMRUFile[type][i][0] == '\0') {
			break;
		}
		_snprintf(string, sizeof(string), "Media%d", i);
		nMRUMedia[type][i] = LoadCfgInt(string, -1);
		nMRUNum[type]++;
	}
}

/*
 *	ݒf[^
 *	[h
 */
void FASTCALL LoadCfg(void)
{
	int i;
	int j;
	char string[128];
	char path[_MAX_PATH];
	char dir[_MAX_DIR];
	char InitDir[_MAX_DRIVE + _MAX_PATH];
	BOOL flag;
	static const int JoyTable[] = {
		0x70, 0x71, 0x72, 0x73, 0, 0x74, 0x75
	};

	SetCfgFile();

	/* GeneralZNV */
	SetCfgSection("General");
	if (!LoadCfgString("Directory", InitDir, MAX_PATH)) {
		GetModuleFileName(NULL, path, sizeof(path));
		_splitpath(path, InitDir, dir, NULL, NULL);
		if (dir[strlen(dir)-1] == '\\') {
			/* Ō̃pX؂L͋Iɍ */
			dir[strlen(dir)-1] = '\0';
		}
		strncat(InitDir, dir, sizeof(InitDir) - strlen(InitDir) - 1);
	}
	for (i=0; i<INITIAL_DIRS; i++) {
		if (!LoadCfgString((char *)InitDirStr[i], InitialDir[i], MAX_PATH)) {
			strncpy(InitialDir[i], InitDir, sizeof(InitDir));
		}
	}

#if XM7_VER >= 2
#if XM7_VER >= 3
	configdat.fm7_ver = LoadCfgInt("Version", 3);
	if ((configdat.fm7_ver < 1) || (configdat.fm7_ver > 3)) {
		configdat.fm7_ver = 3;
	}
#else
	configdat.fm7_ver = LoadCfgInt("Version", 2);
	if ((configdat.fm7_ver < 1) || (configdat.fm7_ver > 2)) {
		configdat.fm7_ver = 2;
	}
#endif
#else
	configdat.fm7_ver = 1;
	configdat.fm_subtype = (BYTE)LoadCfgInt("SubVersion", FMSUB_FM77);
	configdat.lowspeed_mode = LoadCfgBool("LowSpeedMode", FALSE);
#endif
	configdat.boot_mode = LoadCfgInt("BootMode", BOOT_BASIC);
#if XM7_VER == 1 
#ifdef BUBBLE
	if ((configdat.boot_mode < BOOT_BASIC) || (configdat.boot_mode > BOOT_BUBBLE)) {
		configdat.boot_mode = BOOT_BASIC;
	}
	if (configdat.boot_mode == BOOT_BUBBLE && !bubble_available) {
		configdat.boot_mode = BOOT_DOS;
	}
#else
	if ((configdat.boot_mode < BOOT_BASIC) || (configdat.boot_mode > BOOT_DOS)) {
		configdat.boot_mode = BOOT_BASIC;
	}
#endif
#else
	if ((configdat.boot_mode < BOOT_BASIC) || (configdat.boot_mode > BOOT_DOS)) {
		configdat.boot_mode = BOOT_BASIC;
	}
#endif

	i = LoadCfgInt("CycleSteel", 9999);
	if ((i < 0) || (i > 1)) {
		configdat.cycle_steal = LoadCfgBool("CycleSteal", TRUE);
	}
	else {
		configdat.cycle_steal = (BOOL)i;
	}
	configdat.subclock_mode = LoadCfgBool("SubClockMode", FALSE);
	configdat.main_speed = LoadCfgInt("MainSpeed", MAINCYCLES);
	if ((configdat.main_speed < 1) || (configdat.main_speed > 9999)) {
		configdat.main_speed = MAINCYCLES;
	}
	configdat.mmr_speed = LoadCfgInt("MMRSpeed", MAINCYCLES_MMR);
	if ((configdat.mmr_speed < 1) || (configdat.mmr_speed > 9999)) {
		configdat.mmr_speed = MAINCYCLES_MMR;
	}
#if XM7_VER >= 3
	configdat.fmmr_speed = LoadCfgInt("FastMMRSpeed", MAINCYCLES_FMMR);
	if ((configdat.fmmr_speed < 1) || (configdat.fmmr_speed > 9999)) {
		configdat.fmmr_speed = MAINCYCLES_FMMR;
	}
#endif
	configdat.sub_speed = LoadCfgInt("SubSpeed", SUBCYCLES);
	if ((configdat.sub_speed < 1) || (configdat.sub_speed > 9999)) {
		configdat.sub_speed = SUBCYCLES;
	}
#if XM7_VER == 1
	configdat.main_speed_low = LoadCfgInt("MainSpeedLow", MAINCYCLES_LOW);
	if ((configdat.main_speed_low < 1) || (configdat.main_speed_low > 9999)) {
		configdat.main_speed_low = MAINCYCLES_LOW;
	}
	configdat.sub_speed_low = LoadCfgInt("SubSpeedLow", SUBCYCLES_LOW);
	if ((configdat.sub_speed_low < 1) || (configdat.sub_speed_low > 9999)) {
		configdat.sub_speed_low = SUBCYCLES_LOW;
	}
#ifdef JSUB
	configdat.jsub_speed = LoadCfgInt("JsubSpeed", JSUBCYCLES);
	if ((configdat.jsub_speed < 1) || (configdat.jsub_speed > 9999)) {
		configdat.jsub_speed = SUBCYCLES;
	}
#endif
#endif
	configdat.bTapeFull = LoadCfgBool("TapeFullSpeed", TRUE);
	configdat.bCPUFull = LoadCfgBool("FullSpeed", FALSE);
	configdat.bSpeedAdjust = LoadCfgBool("AutoSpeedAdjust", FALSE);
	configdat.bTapeMode = LoadCfgBool("TapeFullSpeedMode", FALSE);
#ifdef FDDSND
	configdat.bFddWait = LoadCfgInt("FDDWait", TRUE);
#endif

	/* GeneralZNV(EBhEʒu) */
	WinPos.x = LoadCfgInt("WindowPosX", -99999);
	WinPos.y = LoadCfgInt("WindowPosY", -99999);

	/* Sʃy[W(B) */
	bHighPriority = LoadCfgBool("HighPriority", FALSE);
	configdat.uTimerResolution = LoadCfgInt("TimerResolution", 1);
	if ((configdat.uTimerResolution < 1) || (configdat.uTimerResolution > 10)) {
		configdat.uTimerResolution = 1;
	}

	/* SoundZNV */
	SetCfgSection("Sound");
	configdat.nSampleRate = LoadCfgInt("SampleRate", 44100);
	if ((configdat.nSampleRate != 0) &&
		(configdat.nSampleRate != 22050) &&
		(configdat.nSampleRate != 25600) &&
		(configdat.nSampleRate != 44100) &&
		(configdat.nSampleRate != 48000) &&
		(configdat.nSampleRate != 51200) &&
		(configdat.nSampleRate != 88200) &&
		(configdat.nSampleRate != 96000)) {
		configdat.nSampleRate = 44100;
	}
	configdat.nSoundBuffer = LoadCfgInt("SoundBuffer", 100);
	if ((configdat.nSoundBuffer < 40) || (configdat.nSoundBuffer > 1000)) {
		configdat.nSoundBuffer = 100;
	}
	configdat.nBeepFreq = LoadCfgInt("BeepFreq", 1200);
	if ((configdat.nBeepFreq < 100) || (configdat.nBeepFreq > 9999)) {
		configdat.nBeepFreq = 1200;
	}
	configdat.bInterpolation = LoadCfgBool("FMHQmode", TRUE);
	configdat.uStereoOut = LoadCfgInt("StereoOut", 0);
	if ((configdat.uStereoOut < 0) || (configdat.uStereoOut > 4)) {
		configdat.uStereoOut = 0;
	}
	configdat.bTapeMon = LoadCfgBool("TapeMon", FALSE);
	configdat.bForceStereo = LoadCfgInt("ForceStereoOutput", FALSE);
#ifdef ROMEO
	configdat.bUseRomeo = LoadCfgBool("UseROMEO", TRUE);
#elif defined(SCCI)
	configdat.bUseSCCI = LoadCfgBool("UseSCCI", TRUE);
#endif
#ifdef FDDSND
	configdat.bFddSound = LoadCfgBool("FDDSound", FALSE);
#endif
	configdat.uChSeparation = LoadCfgInt("ChannelSeparation",
		CHSEPARATION_DEFAULT);
	if (configdat.uChSeparation > 16) {
		configdat.uChSeparation = CHSEPARATION_DEFAULT;
	}
	configdat.nFMVolume = LoadCfgInt("FMVolume", FMVOLUME_DEFAULT);
	if ((configdat.nFMVolume < -96) || (configdat.nFMVolume > 10)) {
		configdat.nFMVolume = FMVOLUME_DEFAULT;
	}
	configdat.nPSGVolume = LoadCfgInt("PSGVolume", PSGVOLUME_DEFAULT);
	if ((configdat.nPSGVolume < -96) || (configdat.nPSGVolume > 10)) {
		configdat.nPSGVolume = PSGVOLUME_DEFAULT;
	}
	configdat.nBeepVolume = LoadCfgInt("BeepVolume", BEEPVOLUME_DEFAULT);
	if ((configdat.nBeepVolume < -96) || (configdat.nBeepVolume > 0)) {
		configdat.nBeepVolume = BEEPVOLUME_DEFAULT;
	}
	configdat.nCMTVolume = LoadCfgInt("CMTVolume", CMTVOLUME_DEFAULT);
	if ((configdat.nCMTVolume < -96) || (configdat.nCMTVolume > 0)) {
		configdat.nCMTVolume = CMTVOLUME_DEFAULT;
	}
#ifdef FDDSND
	configdat.nWaveVolume = LoadCfgInt("WaveVolume", WAVEVOLUME_DEFAULT);
	if ((configdat.nWaveVolume < -96) || (configdat.nWaveVolume > 0)) {
		configdat.nWaveVolume = WAVEVOLUME_DEFAULT;
	}
#endif

	/* KeyboardZNV */
	SetCfgSection("Keyboard");
	configdat.bKbdReal = LoadCfgBool("RealTimeKeyScan", FALSE);
	configdat.bTenCursor = LoadCfgBool("UseArrowFor10Key", FALSE);
	configdat.bArrow8Dir = LoadCfgBool("Arrow8Dir", TRUE);
	flag = FALSE;
	for (i=0; i<256; i++) {
		_snprintf(string, sizeof(string), "Key%d", i);
		j = i;
		configdat.KeyMap[j] = (BYTE)LoadCfgInt(string, 0);
		/* ǂꂩł[hłAok */
		if (configdat.KeyMap[j] != 0) {
			flag = TRUE;
		}
	}
	/* tO~Ă΁AftHg̃}bv炤 */
	if (!flag) {
		GetDefMapKbd(configdat.KeyMap, 0);
	}
#ifdef KBDPASTE
	configdat.uPasteWait = LoadCfgInt("PasteWait", 0);
	configdat.uPasteWaitCntl = LoadCfgInt("PasteWaitCntl", 0);
	configdat.bKeyStrokeModeless = LoadCfgBool("KeyStrokeModeless", FALSE);
#endif

	/* JoyStickZNV */
	SetCfgSection("JoyStick");
	for (i=0; i<2; i++) {
		_snprintf(string, sizeof(string), "Type%d", i);
		configdat.nJoyType[i] = LoadCfgInt(string, 0);
		if ((configdat.nJoyType[i] < 0) || (configdat.nJoyType[i] > 7)) {
			configdat.nJoyType[i] = 0;
		}

		for (j=0; j<2; j++) {
			_snprintf(string, sizeof(string), "Rapid%d", i * 10 + j);
			configdat.nJoyRapid[i][j] = LoadCfgInt(string, 0);
			if ((configdat.nJoyRapid[i][j] < 0) || (configdat.nJoyRapid[i][j] > 9)) {
				configdat.nJoyRapid[i][j] = 0;
			}

		}

		flag = TRUE;
		for (j=0; j<7; j++) {
			_snprintf(string, sizeof(string), "Code%d", i * 10 + j);
			configdat.nJoyCode[i][j] = LoadCfgInt(string, -1);
			if ((configdat.nJoyCode[i][j] < 0) || (configdat.nJoyCode[i][j] > 0x75)) {
				flag = FALSE;
			}
		}
		/* WG[Ȃ珉lݒ */
		if (!flag) {
			for (j=0; j<7; j++) {
				configdat.nJoyCode[i][j] = JoyTable[j];
			}
		}
	}

	/* ScreenZNV */
	SetCfgSection("Screen");
	configdat.nDDResolutionMode = (BYTE)LoadCfgInt("DD480Line", 255);
	if (configdat.nDDResolutionMode == 255) {
		configdat.nDDResolutionMode = (BYTE)LoadCfgInt("DDResolution", 1);
	}
	if (configdat.nDDResolutionMode >= 5) {
		configdat.nDDResolutionMode = DDRES_480LINE;
	}
	configdat.bFullScan = LoadCfgBool("FullScan", FALSE);
	configdat.bFullScanFS = LoadCfgBool("FullScanFS", FALSE);
	configdat.bFullScreen = LoadCfgBool("FullScreen", FALSE);
	configdat.bDoubleSize = LoadCfgBool("DoubleSize", FALSE);
	configdat.bDD480Status = LoadCfgBool("DD480Status", TRUE);
	configdat.bRasterRender = LoadCfgBool("RasterRender", FALSE);
	configdat.bDrawAfterVSYNC = LoadCfgBool("DrawAfterVSYNC", TRUE);
#if XM7_VER == 3
	configdat.bDDtruecolor = LoadCfgBool("DDTrueColor", TRUE);
#else
	configdat.bDDtruecolor = LoadCfgBool("DDTrueColor", FALSE);
#endif
	configdat.bHideStatus = LoadCfgBool("HideStatusBar", FALSE);
#if XM7_VER == 1
	i = LoadCfgInt("GreenMonitor", 9999);
	if (i == 0) {
		configdat.nMonitorType = MONITOR_COLOR;
	}
	else if (i == 1) {
		configdat.nMonitorType = MONITOR_GREEN;
	}
	else {
		configdat.nMonitorType = LoadCfgInt("MonitorType", MONITOR_COLOR);
	}

	if ((configdat.nMonitorType < MONITOR_COLOR) ||
		(configdat.nMonitorType > MONITOR_AMBERYELLOW)) {
		configdat.nMonitorType = MONITOR_COLOR;
	}
#elif XM7_VER == 2
	i = LoadCfgInt("TTLMonitor", 9999);	/* ۂ̌^ƈႤdȂc */
	if (i == 0) {
		configdat.nMonitorType = MONITOR_COLOR;
	}
	else if (i == 1) {
		configdat.nMonitorType = MONITOR_FORCETTLCOLOR;
	}
	else {
		configdat.nMonitorType = LoadCfgInt("MonitorType", MONITOR_COLOR);
	}

	if ((configdat.nMonitorType != MONITOR_COLOR) &&
		(configdat.nMonitorType != MONITOR_FORCETTLCOLOR)) {
		configdat.nMonitorType = MONITOR_COLOR;
	}
#endif
	configdat.bPseudo400Line = LoadCfgBool("Pseudo400Line", FALSE);

	/* OptionZNV */
	SetCfgSection("Option");
	configdat.bOPNEnable = LoadCfgBool("OPNEnable", TRUE);
	configdat.bWHGEnable = LoadCfgBool("WHGEnable", TRUE);
	configdat.bTHGEnable = LoadCfgBool("THGEnable", TRUE);
#if XM7_VER == 1
	configdat.bPSGEnable = LoadCfgBool("PSGEnable", TRUE);
	configdat.bFMXEnable = LoadCfgBool("FMXEnable", FALSE);
#endif
#if XM7_VER >= 2
	configdat.bDigitizeEnable = LoadCfgBool("DigitizeEnable", TRUE);
	configdat.bJCardEnable = LoadCfgBool("JCardEnable", FALSE);
#endif
#if XM7_VER >= 3
	configdat.bExtRAMEnable = LoadCfgBool("ExtRAMEnable", FALSE);
	configdat.uExtRAMMode = (BYTE)LoadCfgInt("ExtRAMMode", 5);
	if ((configdat.uExtRAMMode < 4) || (configdat.uExtRAMMode > 5)) {
		configdat.uExtRAMMode = 5;
	}
#elif XM7_VER == 2 && defined(FMTV151)
	configdat.bExtRAMEnable = bFMTV151;
#endif
#if XM7_VER == 1
#ifdef L4CARD
	configdat.b400LineCardEnable = LoadCfgBool("400LineCardEnable", TRUE);
	configdat.uExtRAMMode = (BYTE)LoadCfgInt("ExtRAMMode", 2);
	if ((configdat.uExtRAMMode < 1) || (configdat.uExtRAMMode > 2)) {
		configdat.uExtRAMMode = 2;
	}
#endif
#ifdef JSUB
	configdat.bJSubEnable = LoadCfgBool("JSubEnable", TRUE);
#endif
#ifdef BUBBLE
	configdat.bBubbleEnable = LoadCfgBool("BubbleEnable", FALSE);
#endif
	configdat.uBankSelectEnable = LoadCfgInt("BankSelectEnable", 0);
	if (configdat.uBankSelectEnable > BANKSEL_RAMFILE) {
		configdat.uBankSelectEnable = BANKSEL_DISABLE;
	}
	configdat.bPCGEnable = LoadCfgBool("PCGEnable", FALSE);
#endif
#ifdef MOUSE
	configdat.bMouseCapture = LoadCfgBool("MouseEmulation", FALSE);
	configdat.nMousePort = (BYTE)LoadCfgInt("MousePort", 1);
	if ((configdat.nMousePort < 1) || (configdat.nMousePort > 3)) {
		configdat.nMousePort = 1;
	}
	configdat.uMidBtnMode = (BYTE)LoadCfgInt("MidBtnMode", MOSCAP_NONE);
	if (configdat.uMidBtnMode > 2) {
		configdat.uMidBtnMode = 0;
	}
#endif

	/* PortsZNV */
#if defined(RSC) || defined(MIDI)
	SetCfgSection("Ports");
#ifdef RSC
	configdat.bCommPortEnable = LoadCfgBool("CommPortEnable", FALSE);
	configdat.uCommPortBps = (BYTE)LoadCfgInt("CommPortBps", 0);
	if (configdat.uCommPortBps > 4) {
		configdat.uCommPortBps = 0;
	}
	configdat.nCommPortNo = LoadCfgInt("CommPort", 1);
	if ((configdat.nCommPortNo < 1) || (configdat.nCommPortNo > 16)) {
		configdat.nCommPortNo = 1;
	}
#endif

#ifdef MIDI
	if (!LoadCfgString("MidiPort", configdat.szMidiDevice, 256)) {
		strncpy(configdat.szMidiDevice, "", sizeof(configdat.szMidiDevice));
	}
	configdat.nMidiDelay = LoadCfgInt("MidiDelay", 100);
	if ((configdat.nMidiDelay < 0) || (configdat.nMidiDelay > 1000)) {
		configdat.nMidiDelay = 100;
	}
	configdat.bMidiDelayMode = LoadCfgBool("MidiDelayMode", TRUE);
#endif
#endif	/* RSC/MIDI */

	/* PrinterZNV */
#ifdef LPRINT
	SetCfgSection("Printer");
	configdat.uPrinterEnable = (BYTE)LoadCfgInt("PrinterEnable", 0);
#ifdef JASTSOUND
	if (configdat.uPrinterEnable > LP_JASTSOUND) {
#else
	if (configdat.uPrinterEnable > LP_LOG) {
#endif
		configdat.uPrinterEnable = 0;
	}
	configdat.bLprUseOsFont = LoadCfgBool("LprUseOsFont", FALSE);
	configdat.bLprOutputKanji = LoadCfgBool("LprOutputKanji", FALSE);
	if (!LoadCfgString("LprOutPath", configdat.szLprLogPath, 256)) {
		strncpy(configdat.szLprLogPath, "\0", sizeof(configdat.szLprLogPath));
	}
#endif /* LPRINT */

	/* Option2ZNV */
#if XM7_VER == 1
	SetCfgSection("Option2");
	configdat.bSubSystemRomXchg = LoadCfgBool("SubSystemRomXchg", FALSE);
	configdat.bKeyModeFlag = LoadCfgBool("KeyModeFlag", FALSE);
	configdat.bKeyIOPort = LoadCfgBool("FM8KeyIOPort", FALSE);
	configdat.bTTLPalet = LoadCfgBool("FM8TTLPalet", FALSE);
	configdat.bFM7IRQ = LoadCfgBool("FM7IRQ", FALSE);
#endif

	/* MiscZNV */
	SetCfgSection("Misc");
	configdat.bPopupSwnd = LoadCfgBool("PopupSwnd", TRUE);
#if XM7_VER >= 3
	configdat.bSubModeFix = LoadCfgBool("SubModeFix", FALSE);
#endif
	configdat.bOFNCentering = LoadCfgBool("OFNCentering", FALSE);
	configdat.bMagusPatch = LoadCfgBool("MagusPatch", TRUE);
	configdat.bRomRamWrite = LoadCfgBool("RomRamWrite", FALSE);

	/* ]łƂ̌݊̂߁AOption2ZNVł͂Ȃɔzu */
#if XM7_VER == 1
	configdat.bMotorOnLowSpeed = LoadCfgBool("MotorOnLowSpeed", TRUE);
#endif

	/* UnofficialZNV */
	SetCfgSection("Unofficial");
	kanji_asis_flag = LoadCfgBool("KanjiAsIs", FALSE);
#if XM7_VER >= 2
	configdat.bLineBoost = LoadCfgBool("LineBoost", FALSE);
#endif
#if XM7_VER >= 3
	bGravestone = LoadCfgBool("Gravestone", FALSE);
	configdat.b400LineTiming = LoadCfgBool("400LineTiming", FALSE);
#endif
#if XM7_VER == 1
	bIsAmberMonitor = LoadCfgBool("AmberYellowMonitor", FALSE);
	configdat.bParityMode = LoadCfgBool("MICRO8ParityMode", TRUE);
#ifdef L4CARD
	ankcg_force_internal = LoadCfgBool("ForceInternalFont", FALSE);
#endif
#endif
	configdat.bAutoDetectKeyMap = LoadCfgBool("AutoDetectKeyMap", FALSE);

	/* StateZNV */
	SetCfgSection("State");
	bMRUMount[MRU_STATE] = LoadCfgBool("Mount", FALSE);
	LoadCfgMRU(MRU_STATE);
	if (LoadCfgString("File", path, _MAX_PATH)) {
		bMRUMount[MRU_STATE] = TRUE;
		SetMRUFile(MRU_STATE, path);
	}

	/* TapeZNV */
	SetCfgSection("Tape");
	bMRUMount[MRU_TAPE] = LoadCfgBool("Mount", FALSE);
	LoadCfgMRU(MRU_TAPE);
	if (LoadCfgString("File", path, _MAX_PATH)) {
		bMRUMount[MRU_TAPE] = TRUE;
		SetMRUFile(MRU_TAPE, path);
	}

	/* MFD#ZNV */
	for (i=0; i<2; i++) {
		_snprintf(string, sizeof(string), "MFD%d", i);
		SetCfgSection(string);
		bMRUMount[MRU_MFD0 + i] = LoadCfgBool("Mount", FALSE);
		bMRUEject[MRU_MFD0 + i] = LoadCfgBool("Eject", FALSE);
		bMRUWritep[MRU_MFD0 + i] = LoadCfgBool("Writep", FALSE);
		LoadCfgMRU(MRU_MFD0 + i);
		if (LoadCfgString("File", path, _MAX_PATH)) {
			bMRUMount[MRU_MFD0 + i] = TRUE;
			SetMRUFile(MRU_MFD0 + i, path);
		}
		if (nMRUMedia[MRU_MFD0 + i][0] == -1) {
			SetMRUMedia(MRU_MFD0 + i, LoadCfgInt("Media", -1));
		}
	}

 #if XM7_VER == 1 && defined(BUBBLE)
	/* Bubble#ZNV */
	for (i=0; i<BMC_UNITS_32; i++) {
		_snprintf(string, sizeof(string), "Bubble%d", i);
		SetCfgSection(string);
		bMRUMount[MRU_BBL0 + i] = LoadCfgBool("Mount", FALSE);
		bMRUEject[MRU_BBL0 + i] = LoadCfgBool("Eject", FALSE);
		bMRUWritep[MRU_BBL0 + i] = LoadCfgBool("Writep", FALSE);
		LoadCfgMRU(MRU_BBL0 + i);
		if (LoadCfgString("File", path, _MAX_PATH)) {
			bMRUMount[MRU_BBL0 + i] = TRUE;
			SetMRUFile(MRU_BBL0 + i, path);
		}
	}
#endif

}

/*
 *	ݒf[^
 *	[h(2{g僂[hp)
 */
BOOL FASTCALL LoadCfg_DoubleSize(void)
{
	/* 2{g僂[h̏ԂǂݍŕԂ */
	SetCfgFile();
	SetCfgSection("Screen");
	return LoadCfgBool("DoubleSize", FALSE);
}

/*
 *	ݒf[^
 *	[h(ݒ胂[hp)
 */
BOOL FASTCALL LoadCfg_LanguageMode(void)
{
	/* 2{g僂[h̏ԂǂݍŕԂ */
	SetCfgFile();
	SetCfgSection("Unofficial");
	return LoadCfgBool("LanguageMode", FALSE);
}

/*
 *	ݒf[^
 *	폜
 */
static void FASTCALL DeleteCfg(char *key)
{
/*
	ASSERT(key);
*/

	WritePrivateProfileString(pszSection, key, NULL, szIniFile);
}

/*
 *	ݒf[^
 *	Z[u()
 */
static void FASTCALL SaveCfgString(char *key, char *string)
{
	ASSERT(key);
	ASSERT(string);

	WritePrivateProfileString(pszSection, key, string, szIniFile);
}

/*
 *	ݒf[^
 *	Z[u(SoCgint)
 */
static void FASTCALL SaveCfgInt(char *key, int dat)
{
	char string[128];

	ASSERT(key);

	_snprintf(string, sizeof(string), "%d", dat);
	SaveCfgString(key, string);
}

/*
 *	ݒf[^
 *	Z[u(BOOL)
 */
static void FASTCALL SaveCfgBool(char *key, BOOL dat)
{
	ASSERT(key);

	if (dat) {
		SaveCfgInt(key, 1);
	}
	else {
		SaveCfgInt(key, 0);
	}
}

/*
 *	ݒf[^
 *	Z[u(MRU)
 */
static void FASTCALL SaveCfgMRU(int type)
{
	int i;
	char string[256];

	ASSERT((type >= 0) && (type < MRU_TYPES));

	/* [v */
	for (i=0; i<MRU_FILES; i++) {
		_snprintf(string, sizeof(string), "File%d", i);
		SaveCfgString(string, szMRUFile[type][i]);

		_snprintf(string, sizeof(string), "Media%d", i);
		if (nMRUMedia[type][i] != -1) {
			SaveCfgInt(string, nMRUMedia[type][i]);
		}
		else {
			DeleteCfg(string);
		}
	}
}

/*
 *	ݒf[^
 *	Z[u
 */
void FASTCALL SaveCfg(void)
{
	int i;
	int j;
	char string[128];

	SetCfgFile();

	/* GeneralZNV */
	SetCfgSection("General");
	DeleteCfg("Directory");		/* V3.3L20Ŏʖ̕ۑɑΉ */
	DeleteCfg("CycleSteel");	/* V3.2L01CycleStealɃL[̂ύX */
	for (i=0; i<INITIAL_DIRS; i++) {
		SaveCfgString((char *)InitDirStr[i], InitialDir[i]);
	}
#if XM7_VER >= 2
	SaveCfgInt("Version", configdat.fm7_ver);
#else
	SaveCfgInt("SubVersion", configdat.fm_subtype);
	SaveCfgBool("LowSpeedMode", configdat.lowspeed_mode);
#endif
	SaveCfgInt("BootMode", configdat.boot_mode);
	SaveCfgBool("CycleSteal", configdat.cycle_steal);
	SaveCfgBool("SubClockMode", configdat.subclock_mode);
	SaveCfgInt("MainSpeed", configdat.main_speed);
	SaveCfgInt("MMRSpeed", configdat.mmr_speed);
#if XM7_VER >= 3
	SaveCfgInt("FastMMRSpeed", configdat.fmmr_speed);
#endif
	SaveCfgInt("SubSpeed", configdat.sub_speed);
#if XM7_VER == 1
	SaveCfgInt("MainSpeedLow", configdat.main_speed_low);
	SaveCfgInt("SubSpeedLow", configdat.sub_speed_low);
#ifdef JSUB
	SaveCfgInt("JsubSpeed", configdat.jsub_speed);
#endif
#endif
	SaveCfgBool("TapeFullSpeed", configdat.bTapeFull);
	SaveCfgBool("TapeFullSpeedMode", configdat.bTapeMode);
	SaveCfgBool("FullSpeed", configdat.bCPUFull);
	SaveCfgBool("AutoSpeedAdjust", configdat.bSpeedAdjust);
#ifdef FDDSND
	SaveCfgBool("FDDWait", configdat.bFddWait);
#endif

	/* GeneralZNV(EBhEʒu) */
	SaveCfgInt("WindowPosX", WinPos.x);
	SaveCfgInt("WindowPosY", WinPos.y);

	/* SoundZNV */
	SetCfgSection("Sound");
	SaveCfgInt("SampleRate", configdat.nSampleRate);
	SaveCfgInt("SoundBuffer", configdat.nSoundBuffer);
	SaveCfgInt("BeepFreq", configdat.nBeepFreq);
	SaveCfgBool("FMHQmode", configdat.bInterpolation);
	SaveCfgInt("StereoOut", configdat.uStereoOut);
	SaveCfgBool("TapeMon", configdat.bTapeMon);
#ifdef ROMEO
	SaveCfgBool("UseROMEO", configdat.bUseRomeo);
#elif defined(SCCI)
	SaveCfgBool("UseSCCI", configdat.bUseSCCI);
#endif
#ifdef FDDSND
	SaveCfgBool("FDDSound", configdat.bFddSound);
#endif
	SaveCfgInt("ChannelSeparation", configdat.uChSeparation);
	SaveCfgInt("FMVolume", configdat.nFMVolume);
	SaveCfgInt("PSGVolume", configdat.nPSGVolume);
	SaveCfgInt("BeepVolume", configdat.nBeepVolume);
	SaveCfgInt("CMTVolume", configdat.nCMTVolume);
#ifdef FDDSND
	SaveCfgInt("WaveVolume", configdat.nWaveVolume);
#endif

	/* KeyboardZNV */
	SetCfgSection("Keyboard");
	SaveCfgBool("RealTimeKeyScan", configdat.bKbdReal);
	SaveCfgBool("UseArrowFor10Key", configdat.bTenCursor);
	SaveCfgBool("Arrow8Dir", configdat.bArrow8Dir);
	if (!bAutoDetectKeyMap) {
		for (i=0; i<256; i++) {
			_snprintf(string, sizeof(string), "Key%d", i);
			DeleteCfg(string);
			if (configdat.KeyMap[i] != 0) {
				SaveCfgInt(string, (BYTE)(configdat.KeyMap[i] & 0x7f));
			}
		}
	}
#ifdef KBDPASTE
	SaveCfgInt("PasteWait", configdat.uPasteWait);
	SaveCfgInt("PasteWaitCntl", configdat.uPasteWaitCntl);
#endif

	/* JoyStickZNV */
	SetCfgSection("JoyStick");
	for (i=0; i<2; i++) {
		_snprintf(string, sizeof(string), "Type%d", i);
		SaveCfgInt(string, configdat.nJoyType[i]);

		for (j=0; j<2; j++) {
			_snprintf(string, sizeof(string), "Rapid%d", i * 10 + j);
			SaveCfgInt(string, configdat.nJoyRapid[i][j]);
		}

		for (j=0; j<7; j++) {
			_snprintf(string, sizeof(string), "Code%d", i * 10 + j);
			SaveCfgInt(string, configdat.nJoyCode[i][j]);
		}
	}

	/* ScreenZNV */
	SetCfgSection("Screen");
	DeleteCfg("DD480Line");		/* V3.4L51DDResolutionɃL[̂ύX */
	DeleteCfg("DrawTiming");	/* V3.4L60ŃX^_Oڂɂp~ */
	SaveCfgInt("DDResolution", configdat.nDDResolutionMode);
	SaveCfgBool("FullScan", configdat.bFullScan);
	SaveCfgBool("FullScanFS", configdat.bFullScanFS);
	SaveCfgBool("FullScreen", configdat.bFullScreen);
	SaveCfgBool("DoubleSize", configdat.bDoubleSize);
	SaveCfgBool("DD480Status", configdat.bDD480Status);
	SaveCfgBool("RasterRender", configdat.bRasterRender);
	SaveCfgBool("DrawAfterVSYNC", configdat.bDrawAfterVSYNC);
	SaveCfgBool("DDTrueColor", configdat.bDDtruecolor);
	SaveCfgBool("HideStatusBar", configdat.bHideStatus);
	DeleteCfg("GreenMonitor");
	DeleteCfg("TTLMonitor");
#if XM7_VER <= 2
	SaveCfgInt("MonitorType", configdat.nMonitorType);
#endif
	SaveCfgBool("Pseudo400Line", configdat.bPseudo400Line);

	/* OptionZNV */
	SetCfgSection("Option");
	DeleteCfg("SubBusyDelay");	/* V3.1Ŕp~ */
	SaveCfgBool("OPNEnable", configdat.bOPNEnable);
	SaveCfgBool("WHGEnable", configdat.bWHGEnable);
	SaveCfgBool("THGEnable", configdat.bTHGEnable);
#if XM7_VER >= 2
	SaveCfgBool("DigitizeEnable", configdat.bDigitizeEnable);
	SaveCfgBool("JCardEnable", configdat.bJCardEnable);
#endif
#if XM7_VER >= 3
	SaveCfgBool("ExtRAMEnable", configdat.bExtRAMEnable);
	SaveCfgInt("ExtRAMMode", configdat.uExtRAMMode);
#endif
#if XM7_VER == 1
#ifdef L4CARD
	SaveCfgBool("400LineCardEnable", configdat.b400LineCardEnable);
	SaveCfgInt("ExtRAMMode", configdat.uExtRAMMode);
#endif
#ifdef JSUB
	SaveCfgBool("JSubEnable", configdat.bJSubEnable);
#endif
#ifdef BUBBLE
	SaveCfgBool("BubbleEnable", configdat.bBubbleEnable);
#endif
	SaveCfgInt("BankSelectEnable", configdat.uBankSelectEnable);
#endif
#ifdef MOUSE
	SaveCfgBool("MouseEmulation", configdat.bMouseCapture);
	SaveCfgInt("MousePort", configdat.nMousePort);
	SaveCfgInt("MidBtnMode", configdat.uMidBtnMode);
#endif

	/* PortsZNV */
#if defined(RSC) || defined(MIDI)
	SetCfgSection("Ports");
#ifdef RSC
	SaveCfgBool("CommPortEnable", configdat.bCommPortEnable);
	SaveCfgInt("CommPortBps", configdat.uCommPortBps);
	SaveCfgInt("CommPort", configdat.nCommPortNo);
#endif
#ifdef MIDI
	SaveCfgString("MidiPort", configdat.szMidiDevice);
	SaveCfgInt("MidiDelay", configdat.nMidiDelay);
	SaveCfgBool("MidiDelayMode", configdat.bMidiDelayMode);
#endif
#endif	/* RSC/MIDI */

	/* PrinterZNV */
#ifdef LPRINT
	SetCfgSection("Printer");
	SaveCfgInt("PrinterEnable", configdat.uPrinterEnable);
	SaveCfgBool("LprUseOsFont", configdat.bLprUseOsFont);
	SaveCfgBool("LprOutputKanji", configdat.bLprOutputKanji);
	SaveCfgString("LprOutPath", configdat.szLprLogPath);
#endif /* LPRINT */

#if XM7_VER == 1
	/* Option2ZNV */
	SetCfgSection("Option2");
	SaveCfgBool("SubSystemRomXchg", configdat.bSubSystemRomXchg);
	SaveCfgBool("KeyModeFlag", configdat.bKeyModeFlag);
	SaveCfgBool("FM8KeyIOPort", configdat.bKeyIOPort);
	SaveCfgBool("FM8TTLPalet", configdat.bTTLPalet);
	SaveCfgBool("FM7IRQ", configdat.bFM7IRQ);
#endif

	/* MiscZNV */
	SetCfgSection("Misc");
	SaveCfgBool("MagusPatch", configdat.bMagusPatch);
	SaveCfgBool("RomRamWrite", configdat.bRomRamWrite);
	SaveCfgBool("OFNCentering", configdat.bOFNCentering);
	SaveCfgBool("PopupSwnd", configdat.bPopupSwnd);
#if XM7_VER == 1
	SaveCfgBool("MotorOnLowSpeed", configdat.bMotorOnLowSpeed);
#endif
	DeleteCfg("FdcEnable");

	/* StateZNV */
	SetCfgSection("State");
	DeleteCfg("File");
	SaveCfgBool("Mount", bMRUMount[MRU_STATE]);
	SaveCfgMRU(MRU_STATE);

	/* TapeZNV */
	SetCfgSection("Tape");
	DeleteCfg("File");
	SaveCfgBool("Mount", tape_fileh != -1);
	SaveCfgMRU(MRU_TAPE);

	/* MFD#ZNV */
	for (i=0; i<2; i++) {
		_snprintf(string, sizeof(string), "MFD%d", i);
		SetCfgSection(string);
		DeleteCfg("File");
		DeleteCfg("Eject");
		DeleteCfg("Media");
		DeleteCfg("Writep");
		SaveCfgBool("Mount", fdc_ready[i] != FDC_TYPE_NOTREADY);
		if (fdc_ready[i] != FDC_TYPE_NOTREADY) {
			if (fdc_ready[i] != FDC_TYPE_D77) {
				SaveCfgBool("Writep", fdc_writep[i]);
			}
		}
		SaveCfgMRU(MRU_MFD0 + i);
	}

 #if XM7_VER == 1 && defined(BUBBLE)
	/* Bubble#ZNV */
	for (i=0; i<BMC_UNITS_32; i++) {
		_snprintf(string, sizeof(string), "Bubble%d", i);
		SetCfgSection(string);
		DeleteCfg("File");
		DeleteCfg("Eject");
		DeleteCfg("Media");
		DeleteCfg("Writep");
		SaveCfgBool("Mount", bmc_ready[i] != BMC_TYPE_NOTREADY);
		if ((bmc_ready[i] != BMC_TYPE_NOTREADY) &&
			(bmc_ready[i] != BMC_TYPE_B77)) {
			SaveCfgBool("Writep", bmc_writep[i]);
		}
		SaveCfgMRU(MRU_BBL0 + i);
	}
#endif
}

/*
 *	ݒf[^Kp
 *	VM̃bN͍sĂȂ̂Œ
 */
void FASTCALL ApplyCfg(void)
{
	BYTE keymap_temp[256];
	RECT rect;
	int i;
	char tmp[128];
	char buffer[256+128+1];
	BOOL system_reset_flag;

	system_reset_flag = FALSE;
	tmp[0] = '\0';
	buffer[0] = '\0';

	/* GeneralZNV */
	fm7_ver = configdat.fm7_ver;
	boot_mode = configdat.boot_mode;
	cycle_steal = configdat.cycle_steal;
	cycle_steal_default = configdat.cycle_steal;
	subclock_mode = configdat.subclock_mode;
	main_speed = configdat.main_speed * 10;
	mmr_speed = configdat.mmr_speed * 10;
#if XM7_VER >= 3
	fmmr_speed = configdat.fmmr_speed * 10;
#endif
	sub_speed = configdat.sub_speed * 10;
	bTapeFullSpeed = configdat.bTapeFull;
	bFullSpeed = configdat.bCPUFull;
	bAutoSpeedAdjust = configdat.bSpeedAdjust;
	uTimerResolution = configdat.uTimerResolution;
#ifdef FDDSND
	fdc_waitmode = configdat.bFddWait;
#endif
	bTapeModeType = configdat.bTapeMode;
#if XM7_VER == 1
	/* gpsȃ[hIĂꍇAIɃ[hύX */
	if ((configdat.fm_subtype == FMSUB_FM8) && !available_fm8roms) {
		configdat.fm_subtype = FMSUB_FM77;
	}
	else if ((configdat.fm_subtype != FMSUB_FM8) && !available_fm7roms) {
		configdat.fm_subtype = FMSUB_FM8;
	}

	fm_subtype = configdat.fm_subtype;
	lowspeed_mode = configdat.lowspeed_mode;
	main_speed_low = configdat.main_speed_low * 10;
	sub_speed_low = configdat.sub_speed_low * 10;
#ifdef JSUB
	jsub_speed = configdat.jsub_speed * 10;
#endif
#endif

	/* SoundZNV */
	nSampleRate = configdat.nSampleRate;
	nSoundBuffer = configdat.nSoundBuffer;
	nBeepFreq = configdat.nBeepFreq;
	bInterpolation = configdat.bInterpolation;
	uStereoOut = configdat.uStereoOut;
	bForceStereo = configdat.bForceStereo;
	bTapeMon = configdat.bTapeMon;
	tape_monitor = configdat.bTapeMon;
#ifdef ROMEO
	if (bRomeo) {
		bUseRomeo = configdat.bUseRomeo;
		juliet_YMF288Mute(!bUseRomeo);
	}
	else {
		bUseRomeo = FALSE;
	}
#elif defined(SCCI)
	if (bSCCI_available) {
		bUseSCCI = configdat.bUseSCCI;
		SCCI_Mute(!bUseSCCI);
	}
	else {
		bUseSCCI = FALSE;
	}
#endif
	uChSeparation = configdat.uChSeparation;
	nFMVolume = configdat.nFMVolume;
	nPSGVolume = configdat.nPSGVolume;
	nBeepVolume = configdat.nBeepVolume;
	nCMTVolume = configdat.nCMTVolume;
#ifdef FDDSND
	fdc_sound = configdat.bFddSound;
	tape_sound = configdat.bFddSound;
	nWaveVolume = configdat.nWaveVolume;
#endif
	ApplySnd();

	/* KeyboardZNV */
	if (!configdat.bAutoDetectKeyMap) {
		SetMapKbd(configdat.KeyMap);
	}
	bKbdReal = configdat.bKbdReal;
	bTenCursor = configdat.bTenCursor;
	bArrow8Dir = configdat.bArrow8Dir;
#ifdef KBDPASTE
	uPasteWait = configdat.uPasteWait;
	uPasteWaitCntl = configdat.uPasteWaitCntl;
	bKeyStrokeModeless = configdat.bKeyStrokeModeless;
#endif

	/* JoyStickZNV */
	memcpy(nJoyType, configdat.nJoyType, sizeof(nJoyType));
	memcpy(nJoyRapid, configdat.nJoyRapid, sizeof(nJoyRapid));
	memcpy(nJoyCode, configdat.nJoyCode, sizeof(nJoyCode));
	/* h!FMȊÕv^|[gڑWCXeBbN2ɐڑłȂ */
	if ((configdat.nJoyType[0] >= 4) && (configdat.nJoyType[1] >= 4) &&
		!((configdat.nJoyType[0] == 6) && (configdat.nJoyType[1] == 7)) &&
		!((configdat.nJoyType[0] == 7) && (configdat.nJoyType[1] == 6))) {
		/* |[g1D */
		configdat.nJoyType[1] = 0;
	}
	/* tapelp.cp̃v^|[gڑWCXeBbÑ^Cvݒ */
	for (i=0; i<2; i++) {
		switch (configdat.nJoyType[i]) {
			case 4:	/* dgVЃWCXeBbN */
					lp_joysticktype = LPJOY_DEMPA;
					break;
			case 5:	/* ASCII QuickShot */
					lp_joysticktype = LPJOY_ASCII;
					break;
			case 6:	/* h!FMWWCXeBbN(|[g1) */
					lp_joysticktype = LPJOY_OHFM;
					break;
			default:
					break;
		}
	}

	/* ScreenZNV */
	nDDResolutionMode = configdat.nDDResolutionMode;
	bFullScan = configdat.bFullScan;
	bFullScanFS = configdat.bFullScanFS;
	if (bDrawSelected) {
		if (bFullScreen != configdat.bFullScreen) {
			PostMessage(hMainWnd, WM_COMMAND, IDM_FULLSCREEN, 0);
		}
	}
	else {
		bFullRequested = configdat.bFullScreen;
		bFullScreen = FALSE;
	}
	bDoubleSize = configdat.bDoubleSize;
	bDD480Status = configdat.bDD480Status;
	if (bRasterRendering != configdat.bRasterRender) {
		SelectCancelGDI();
	}
	bRasterRendering = configdat.bRasterRender;
	draw_aftervsync = configdat.bDrawAfterVSYNC;
	bDDtruecolor = configdat.bDDtruecolor;
	bHideStatus = configdat.bHideStatus;
#if XM7_VER <= 2
	nMonitorType = configdat.nMonitorType;
#endif
	bPseudo400Line = configdat.bPseudo400Line;
#if XM7_VER >= 2
	if (bFullSpeed) {
		line_boost = TRUE;
	}
	else {
		line_boost = configdat.bLineBoost;
	}
#endif

	/* OptionZNV */
	opn_enable = configdat.bOPNEnable;
	whg_enable = configdat.bWHGEnable;
	thg_enable = configdat.bTHGEnable;
#if XM7_VER == 1
	psg_enable = configdat.bPSGEnable;
	fmx_flag = configdat.bFMXEnable;
#endif
#if XM7_VER >= 2
	digitize_enable = configdat.bDigitizeEnable;
	if ((jcard_enable != configdat.bJCardEnable) && (fm7_ver == 2)) {
		jcard_enable = configdat.bJCardEnable;
		system_reset_flag = TRUE;
	}
	else {
		jcard_enable = configdat.bJCardEnable;
	}
#endif
#if XM7_VER >= 3
	mmr_extram = configdat.bExtRAMEnable;

	/* gRAM샂[h(ȂXM7dash݊) */
	if (configdat.uExtRAMMode == 5) {
		mmr_768kbmode = TRUE;
	}
	else {
		mmr_768kbmode = FALSE;
	}
#elif XM7_VER == 2 && defined(FMTV151)
	bFMTV151 = configdat.bExtRAMEnable;
#endif
#if XM7_VER == 1
#ifdef L4CARD
	if (detect_400linecard) {
		/* EnableDisable400C[hɂȂĂ鎞͋Zbg */
		if ((fm_subtype == FMSUB_FM77) &&
			enable_400linecard && !configdat.b400LineCardEnable &&
			enable_400line) {
			system_reset_flag = TRUE;
			OnRefresh(hMainWnd);
		}
		enable_400linecard = configdat.b400LineCardEnable;
	}
	else {
		enable_400linecard = FALSE;
	}

	/* gRAM샂[h(ȂXM7dash݊) */
	if (configdat.uExtRAMMode == 1) {
		mmr_64kbmode = TRUE;
	}
	else {
		mmr_64kbmode = FALSE;
	}
#endif
#ifdef JSUB
	if (jsub_available) {
		jsub_enable = configdat.bJSubEnable;
	}
	else {
		jsub_enable = FALSE;
	}
#endif
#ifdef BUBBLE
	bmc_enable = configdat.bBubbleEnable;
#endif
	pcg_enable = configdat.bPCGEnable;
#endif
#ifdef MOUSE
	mos_capture = configdat.bMouseCapture;
	if (((mos_port >= 1) && (mos_port <= 2) && (configdat.nMousePort == 3)) ||
		 ((configdat.nMousePort >= 1) && (configdat.nMousePort <= 2) &&
		 (mos_port == 3))) {
		mos_port = configdat.nMousePort;
		system_reset_flag = TRUE;
	}
	else {
		mos_port = configdat.nMousePort;
	}
	uMidBtnMode = configdat.uMidBtnMode;
#endif

	/* PortsZNV */
#ifdef RSC
	rs_use = configdat.bCommPortEnable;
	rs_baudrate_v2 = configdat.uCommPortBps;
	nCommPortNo = configdat.nCommPortNo;
#endif
#ifdef MIDI
	strncpy(szMidiDevice, configdat.szMidiDevice, sizeof(szMidiDevice));
	nMidiDelay = configdat.nMidiDelay;
	bMidiDelayMode = configdat.bMidiDelayMode;
#endif

	/* PrinterZNV */
#ifdef LPRINT
	if ((lp_use != configdat.uPrinterEnable) ||
		((configdat.uPrinterEnable == LP_LOG) &&
		(strcmp(lp_fname, configdat.szLprLogPath) != 0))) {
		/* [h؂ւ̃t@CN[Y/I[vōs */
		lp_use = configdat.uPrinterEnable;
		switch (lp_use) {
			case LP_EMULATION:
				lp_setfile(LP_TEMPFILENAME);
				break;
			case LP_LOG:
				if (configdat.szLprLogPath[0] == '\0') {
					lp_setfile(NULL);
				}
				else {
					lp_setfile(configdat.szLprLogPath);
					if (lp_fileh == -1) {
						LoadString(hAppInstance, IDS_LPRLOGERROR,
							tmp, sizeof(tmp));
						_snprintf(buffer, sizeof(buffer), tmp,
							configdat.szLprLogPath);
						MessageBox(hMainWnd, buffer, "XM7",
							MB_ICONEXCLAMATION | MB_OK);
					}
				}
				break;
			case LP_JASTSOUND:
			case LP_DISABLE:
				lp_setfile(NULL);
				break;
			default:
				ASSERT(FALSE);
		}
	}

	lpr_use_os_font = configdat.bLprUseOsFont;
	lpr_output_kanji = configdat.bLprOutputKanji;
#endif

	/* Option2ZNV */
#if XM7_VER == 1
	banksel_en = configdat.uBankSelectEnable;
	pcg_enable = configdat.bPCGEnable;
	if ((fm_subtype == FMSUB_FM8) && 
		(subrom_xchg != configdat.bSubSystemRomXchg)) {
		system_reset_flag = TRUE;
	}
	subrom_xchg = configdat.bSubSystemRomXchg;
	key_mode_flag = configdat.bKeyModeFlag;
	keyport_en = configdat.bKeyIOPort;
	ttl_palet_en = configdat.bTTLPalet;
	if ((fm_subtype == FMSUB_FM8) && fm7irq_en != configdat.bFM7IRQ) {
		system_reset_flag = TRUE;
	}
	fm7irq_en = configdat.bFM7IRQ;

	if ((fm_subtype == FMSUB_FM8) && !banksel_en) {
		/* FM-8[h̏ꍇF-BASIC ROMLEĐݒ */
		if (boot_mode == BOOT_BASIC) {
			basicrom_en = TRUE;
		}
		else {
			basicrom_en = FALSE;
		}
	}
#endif

	/* MiscZNV */
	if (bPopupSwnd != configdat.bPopupSwnd) {
		for (i=0; i<SWND_MAXNUM; i++) {
			if (hSubWnd[i]) {
				DestroyWindow(hSubWnd[i]);
				hSubWnd[i] = NULL;
			}
		}
	}
	bPopupSwnd = configdat.bPopupSwnd;
#if XM7_VER == 1
	motoron_lowspeed = configdat.bMotorOnLowSpeed;
#endif
#if XM7_VER == 3
	submode_fix = configdat.bSubModeFix;
#endif
	bOFNCentering = configdat.bOFNCentering;
	magus_patch = configdat.bMagusPatch;
	rom_ram_write = configdat.bRomRamWrite;

	/* UnofficialZNV */
	bAutoDetectKeyMap = configdat.bAutoDetectKeyMap;
	if (bAutoDetectKeyMap) {
		GetDefMapKbd(keymap_temp, 0);
		SetMapKbd(keymap_temp);
	}
#if XM7_VER >= 3
	dsp_400linetiming = configdat.b400LineTiming;
#endif
#if XM7_VER == 1
	paritymode = configdat.bParityMode;
#endif

	/* Zbg */
	if (system_reset_flag) {
		system_reset();
		StatePath[0] = '\0';
		SetAllMRUFile();
		if (hMainWnd) {
			OnRefresh(hMainWnd);
		}
	}

	/* Xe[^Xo[̃TCY */
	if (hStatusBar) {
		if (bHideStatus) {
			/*  */
			ShowWindow(hStatusBar, SW_HIDE);
		}
		else {
			/* \ */
			ShowWindow(hStatusBar, SW_SHOW);
		}

		/* t[EChẼTCY␳ */
		GetClientRect(hMainWnd, &rect);
		PostMessage(hMainWnd, WM_SIZE, 0, MAKELPARAM(rect.right, rect.bottom));
	}

	/* \eXV */
	if (hMainWnd) {
		OnSize(hMainWnd, 640, 400);
	}
	if (hDrawWnd) {
		InvalidateRect(hDrawWnd, NULL, FALSE);
	}
	display_notify();
}

/*
 *	ݒf[^擾
 */
void FASTCALL GetCfg(void)
{
	/* GeneralZNV */
	configdat.fm7_ver = fm7_ver;
	configdat.boot_mode = boot_mode;
	configdat.cycle_steal = cycle_steal_default;
	configdat.subclock_mode = subclock_mode;
	configdat.main_speed = main_speed / 10;
	configdat.mmr_speed = mmr_speed / 10;
#if XM7_VER >= 3
	configdat.fmmr_speed = fmmr_speed / 10;
#endif
	configdat.sub_speed = sub_speed / 10;
	configdat.bTapeFull = bTapeFullSpeed;
	configdat.bCPUFull = bFullSpeed;
	configdat.bSpeedAdjust = bAutoSpeedAdjust;
	configdat.bTapeMode = bTapeModeType;
#if XM7_VER == 1
	configdat.fm_subtype = fm_subtype;
	configdat.lowspeed_mode = lowspeed_mode;
	configdat.main_speed_low = main_speed_low / 10;
	configdat.sub_speed_low = sub_speed_low / 10;
#ifdef JSUB
	configdat.jsub_speed = jsub_speed / 10;
#endif
#endif

	/* ScreenZNV */
	configdat.bFullScreen = bFullScreen;
	configdat.bHideStatus = bHideStatus;

	/* OptionZNV */
	configdat.bOPNEnable = opn_enable;
	configdat.bWHGEnable = whg_enable;
	configdat.bTHGEnable = thg_enable;
#if XM7_VER >= 2
	configdat.bDigitizeEnable = digitize_enable;
#if XM7_VER == 2
	if (jcard_available) {
		configdat.bJCardEnable = jcard_enable;
	}
	else {
		configdat.bJCardEnable = FALSE;
	}
#else
	configdat.bJCardEnable = jcard_enable;
#endif
#endif
#if XM7_VER >= 3
	configdat.bExtRAMEnable = mmr_extram;
#endif
#if XM7_VER == 1
#ifdef L4CARD
	if (detect_400linecard) {
		configdat.b400LineCardEnable = enable_400linecard;
	}
	else {
		configdat.b400LineCardEnable = FALSE;
	}
#endif
#ifdef JSUB
	if (jsub_available) {
		configdat.bJSubEnable = jsub_enable;
	}
	else {
		configdat.bJSubEnable = FALSE;
	}
#endif
#ifdef BUBBLE
	configdat.bBubbleEnable = bmc_enable;
#endif
	configdat.uBankSelectEnable = banksel_en;
	configdat.bMotorOnLowSpeed = motoron_lowspeed;
	configdat.bSubSystemRomXchg = subrom_xchg;
	configdat.bKeyModeFlag = key_mode_flag;
	configdat.bKeyIOPort = keyport_en;
	configdat.bTTLPalet = ttl_palet_en;
	configdat.bFM7IRQ = fm7irq_en;
#endif
}

/*
 *	@Đݒ
 */
void FASTCALL SetMachineVersion(void)
{
	configdat.fm7_ver = fm7_ver;
#if XM7_VER == 1
	configdat.fm_subtype = fm_subtype;
#endif
}

/*
 *	MRUZbg
 */
void FASTCALL SetMRUFile(int type, char *string)
{
	int i, j, num;

	ASSERT((type >= 0) && (type < MRU_TYPES));
	ASSERT(string);

	if (strlen(string) == 0) {
		return;
	}

	/* ɓ̂Ȃ */
	num = GetMRUNum(type);
	for (i=0; i<num; i++) {
		if (strcmp(szMRUFile[type][i], string) == 0) {
			/* 擪ɂāA܂̂ǉ悤Ƃ */
			if (i == 0) {
				return;
			}

			/* ړ */
			for (j=i; j>0; j--) {
				memcpy(szMRUFile[type][j], szMRUFile[type][j - 1], _MAX_PATH);
				nMRUMedia[type][j] = nMRUMedia[type][j - 1];
			}

			/* 擪ɃZbg */
			ASSERT(strlen(string) < _MAX_PATH);
			strncpy(szMRUFile[type][0], string, _MAX_PATH);
			nMRUMedia[type][0] = -1;
			return;
		}
	}

	/* ړ */
	for (i=MRU_FILES-1; i>0; i--) {
		memcpy(szMRUFile[type][i], szMRUFile[type][i - 1], _MAX_PATH);
		nMRUMedia[type][i] = nMRUMedia[type][i - 1];
	}

	/* 擪ɃZbg */
	ASSERT(strlen(string) < _MAX_PATH);
	strncpy(szMRUFile[type][0], string, _MAX_PATH);
	nMRUMedia[type][0] = -1;

	/* XV */
	if (nMRUNum[type] < MRU_FILES) {
		nMRUNum[type]++;
	}
}

/*
 *	MediaZbg
 */
void FASTCALL SetMRUMedia(int type, int media)
{
	ASSERT((type >= 0) && (type < MRU_TYPES));
	ASSERT((media >= -1) && (media < MRU_MEDIAS));

	/* 擪ɃZbg */
	nMRUMedia[type][0] = media;
}

/*
 *	MRU擾
 */
void FASTCALL GetMRUFile(int type, int index, char *string, size_t nlen)
{
	ASSERT((type >= 0) && (type < MRU_TYPES));
	ASSERT((index >= 0) && (index < MRU_FILES));
	ASSERT(string);

	/* ȏȂ\0 */
	if (index >= nMRUNum[type]) {
		string[0] = '\0';
		return;
	}

	/* Rs[ */
	ASSERT(strlen(szMRUFile[type][index]) < nlen);
	strncpy(string, szMRUFile[type][index], nlen);
}

/*
 *	Media擾
 */
int FASTCALL GetMRUMedia(int type, int index)
{
	ASSERT((type >= 0) && (type < MRU_TYPES));
	ASSERT((index >= 0) && (index < MRU_FILES));

	/* ȏȂ-1 */
	if (index >= nMRUNum[type]) {
		return -1;
	}

	/* 擪ɃZbg */
	return nMRUMedia[type][index];
}

/*
 *	MRU폜
 */
void FASTCALL DelMRUFile(int type, int index)
{
	int i;

	ASSERT((type >= 0) && (type < MRU_TYPES));
	ASSERT((index >= 0) && (index < MRU_FILES));

	/* ȏȂȂɂȂ */
	if (index >= nMRUNum[type]) {
		return;
	}

	/* ړ */
	for (i=index; i<MRU_FILES-1; i++) {
		memcpy(szMRUFile[type][i], szMRUFile[type][i + 1], _MAX_PATH);
		nMRUMedia[type][i] = nMRUMedia[type][i + 1];
	}
	memset(szMRUFile[type][MRU_FILES-1], 0, _MAX_PATH);
	nMRUMedia[type][MRU_FILES-1] = -1;

	/* XV */
	if (nMRUNum[type] > 0) {
		nMRUNum[type]--;
	}
}

/*
 *	MRU擾
 */
int FASTCALL GetMRUNum(int type)
{
	ASSERT((type >= 0) && (type < MRU_TYPES));

	return nMRUNum[type];
}

/*
 *	SMRUZbg
 */
void FASTCALL SetAllMRUFile(void)
{
	int i;

	/* Xe[g */
	if (StatePath[0] != '\0') {
		SetMRUFile(MRU_STATE, StatePath);
		bMRUMount[MRU_STATE] = TRUE;
	}
	else {
		bMRUMount[MRU_STATE] = FALSE;
	}

	/* e[v */
	if (tape_fileh != -1) {
		SetMRUFile(MRU_TAPE, tape_fname);
	}

	for (i=0; i<2; i++) {
		if (fdc_ready[i] != FDC_TYPE_NOTREADY) {
			SetMRUFile(MRU_MFD0 + i, fdc_fname[i]);
			if (fdc_ready[i] == FDC_TYPE_D77) {
				SetMRUMedia(MRU_MFD0 + i, fdc_media[i]);
			}
		}
	}

#if XM7_VER == 1 && defined(BUBBLE)
	/* ouJZbg */
	for (i=0; i<BMC_UNITS_32; i++) {
		if (bmc_ready[i] != BMC_TYPE_NOTREADY) {
			SetMRUFile(MRU_BBL0 + i, bmc_fname[i]);
			if (bmc_ready[i] == BMC_TYPE_B77) {
				SetMRUMedia(MRU_BBL0 + i, bmc_media[i]);
			}
		}
	}
#endif	/* XM7_VER == 1 && defined(BUBBLE) */
}

/*-[ wvT|[g ]-------------------------------------------------------*/

/*
 *	T|[gIDXg
 *	(ɗ̂قǗD)
 */
static const UINT PageHelpList[] = {
#if XM7_VER >= 3
	IDC_GP_FM7,
	IDC_GP_FM77AV,
	IDC_GP_AV40EX,
#elif XM7_VER == 1
	IDC_GP_FM8,
	IDC_GP_FM7,
	IDC_GP_FM77,
	IDC_GP_HIGHSPEED,
#else
	IDC_GP_MACHINEG,
#endif
	IDC_GP_HIGHSPEED,
	IDC_GP_MIDSPEED,
	IDC_GP_LOWSPEED,
	IDC_GP_TAPESPEED,
	IDC_GP_TAPESPEEDMODE,
	IDC_GP_FULLSPEED,
	IDC_GP_AUTOSPEEDADJUST,
#ifdef FDDSND
	IDC_GP_FDDWAIT,
#endif
	IDC_GP_CPUDEFAULT,
	IDC_GP_SPEEDG,
	IDC_SP_HQMODE,
	IDC_SP_RATEG,
	IDC_SP_BUFFERG,
	IDC_SP_STEREO,
	IDC_SP_TAPEMON,
#ifdef FDDSND
	IDC_SP_FDDSOUND,
#endif
#ifdef ROMEO
	IDC_SP_ROMEO,
#elif defined(SCCI)
	IDC_SP_SCCI,
#endif
	IDC_SP_BEEPG,
	IDC_VP_DEFAULT,
	IDC_VP_SEPARATIONG,
	IDC_VP_VOLUMEG,
	IDC_KP_LIST,
	IDC_KP_101B,
	IDC_KP_106B,
	IDC_KP_98B,
	IDC_KP_USEARROWFOR10,
	IDC_KP_ARROW8DIR,
	IDC_KP_KBDREAL,
	IDC_JP_PORTG,
	IDC_JP_TYPEG,
	IDC_JP_RAPIDG,
	IDC_JP_CODEG,
#ifdef MIDI
	IDC_POP_MIDIDLY,
	IDC_POP_MIDIDLYSB,
	IDC_POP_MIDIG,
#endif
#ifdef RSC
	IDC_POP_COMENABLE,
	IDC_POP_COMBPSC,
	IDC_POP_COMG,
#endif
#ifdef LPRINT
	IDC_LPP_LPREMUENABLE,
	IDC_LPP_LPROSFNT,
	IDC_LPP_LPRKANJI,
	IDC_LPP_LPRLOGENABLE,
	IDC_LPP_LPRLOGPATH,
	IDC_LPP_LPRLOGPATHNAME,
	IDC_LPP_LPRLOGDIALOG,
#ifdef JASTSOUND
	IDC_LPP_LPRJASTSOUNDENABLE,
#endif
	IDC_LPP_LPRDISABLE,
	IDC_LPP_LPRG,
#endif
	IDC_SCP_MODEC,
	IDC_SCP_24K,
	IDC_SCP_24KFS,
	IDC_SCP_DOUBLESIZE,
	IDC_SCP_CAPTIONB,
	IDC_SCP_TRUECOLOR,
	IDC_SCP_RASTERRENDER,
#if XM7_VER <= 2
	IDC_SCP_MONITORTYPE,
#endif
	IDC_SCP_PSEUDO400LINE,
	IDC_SCP_MODEG,
	IDC_OP_OPNB,
	IDC_OP_WHGB,
	IDC_OP_THGB,
	IDC_OP_DIGITIZEG,
#if XM7_VER == 1
#ifdef L4CARD
	IDC_OP_400LINEG,
#endif
#ifdef JSUB
	IDC_OP_JSUBG,
#endif
#ifdef BUBBLE
	IDC_OP_BMCG,
#endif
#endif
#if XM7_VER >= 2
	IDC_OP_JCARDG,
#endif
#if ((XM7_VER >= 3) || (XM7_VER == 2 && defined(FMTV151)))
	IDC_OP_RAMG,
#endif
#ifdef MOUSE
	IDC_OP_MOUSEEM,
	IDC_OP_MOUSESW,
	IDC_OP_MOUSEG,
#endif
#if XM7_VER == 1
	IDC_AP_PSG,
	IDC_AP_BANKSELL,
	IDC_AP_BANKSELB,
	IDC_AP_BANKSEL,
	IDC_AP_SUBSYS,
	IDC_AP_KEY,
	IDC_AP_TAPECPUSPEED,
	IDC_AP_KEYIOPORT,
	IDC_AP_TTLPALET,
	IDC_AP_FM7IRQ,
	IDC_AP_FM8OPT,
#endif
	IDC_EP_MAGUSPATCH,
	IDC_EP_ROMRAMWRITE,
	IDC_EP_OFNCENTERING,
	IDC_EP_POPUPSWND,
	0
};

/*
 *	y[Wwv
 */
static void FASTCALL PageHelp(HWND hDlg, UINT uID)
{
	POINT point;
	RECT rect;
	HWND hWnd;
	int i;
	char string[256];
	UINT uHelpID;

	ASSERT(hDlg);

	/* |Cg쐬 */
	GetCursorPos(&point);

	/* wvXgɍڂĂID */
	for (i=0; ;i++) {
		/* I`FbN */
		if (PageHelpList[i] == 0) {
			break;
		}

		/* EChEnh擾 */
		hWnd = GetDlgItem(hDlg, PageHelpList[i]);
		if (!hWnd) {
			continue;
		}
		if (!IsWindowVisible(hWnd)) {
			continue;
		}

		/* `𓾂āAPtInRectŃ`FbN */
		GetWindowRect(hWnd, &rect);
		if (!PtInRect(&rect, point)) {
			continue;
		}

		/* LbV`FbN */
		if (PageHelpList[i] == uPropertyHelp) {
			return;
		}
		uPropertyHelp = PageHelpList[i];

		/* ꕔ\[XID̓ւ */
		uHelpID = uPropertyHelp;
#ifdef MOUSE
		if (uPropertyHelp == IDC_OP_MOUSESWC) {
			uHelpID = IDC_OP_MOUSESW;
		}
#endif

		/* 񃊃\[X[hAݒ */
		string[0] = '\0';
		LoadString(hAppInstance, uHelpID, string, sizeof(string));
		hWnd = GetDlgItem(hDlg, uID);
		if (hWnd) {
			SetWindowText(hWnd, string);
		}

		/* ݒI */
		return;
	}

	/* wvXg͈͊Ő`BȂ */
	if (uPropertyHelp == 0) {
		return;
	}
	uPropertyHelp = 0;

	string[0] = '\0';
	hWnd = GetDlgItem(hDlg, uID);
	if (hWnd) {
		SetWindowText(hWnd, string);
	}
}

/*-[ Sʃy[W ]-----------------------------------------------------------*/

/*
 *	Sʃy[W
 *	_CAO
 */
static void FASTCALL GeneralPageInit(HWND hDlg)
{
	HWND hWnd;
	char string[128];

	ASSERT(hDlg);

	/* V[g */
	SheetInit(hDlg);

	/* @ */
#if XM7_VER >= 2
	switch (propdat.fm7_ver) {
		case 1:
			CheckDlgButton(hDlg, IDC_GP_FM7, BST_CHECKED);
			break;
		case 2:
			CheckDlgButton(hDlg, IDC_GP_FM77AV, BST_CHECKED);
			break;
#if XM7_VER >= 3
		case 3:
			CheckDlgButton(hDlg, IDC_GP_AV40EX, BST_CHECKED);
			break;
#endif
	}
#else
	if (propdat.fm_subtype == FMSUB_FM8) {
		CheckDlgButton(hDlg, IDC_GP_FM8, BST_CHECKED);
	}
	else if (propdat.fm_subtype == FMSUB_FM7) {
		CheckDlgButton(hDlg, IDC_GP_FM7, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_GP_FM77, BST_CHECKED);
	}

	hWnd = GetDlgItem(hDlg, IDC_GP_FM8);
	EnableWindow(hWnd, available_fm8roms);
	hWnd = GetDlgItem(hDlg, IDC_GP_FM7);
	EnableWindow(hWnd, available_fm7roms);
	hWnd = GetDlgItem(hDlg, IDC_GP_FM77);
	EnableWindow(hWnd, available_fm7roms);

	/* CCPUNbN */
	if (propdat.lowspeed_mode) {
		CheckDlgButton(hDlg, IDC_GP_MAIN1MHZ, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_GP_MAIN2MHZ, BST_CHECKED);
	}
#endif

	/* 샂[h */
	if (propdat.cycle_steal) {
		CheckDlgButton(hDlg, IDC_GP_HIGHSPEED, BST_CHECKED);
	}
	else if (!propdat.subclock_mode) {
		CheckDlgButton(hDlg, IDC_GP_MIDSPEED, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_GP_LOWSPEED, BST_CHECKED);
	}

	/* CPUI */
	hWnd = GetDlgItem(hDlg, IDC_GP_CPUCOMBO);
	ASSERT(hWnd);
	string[0] = '\0';
	(void)ComboBox_ResetContent(hWnd);
	LoadString(hAppInstance, IDS_GP_MAINCPU, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
#if XM7_VER >= 2
	LoadString(hAppInstance, IDS_GP_MAINMMR, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
#if XM7_VER >= 3
	LoadString(hAppInstance, IDS_GP_FASTMMR, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
#endif
	LoadString(hAppInstance, IDS_GP_SUBCPU, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
#else
	LoadString(hAppInstance, IDS_GP_MAINCPU_LOW, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_GP_MAINMMR, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_GP_SUBCPU, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_GP_SUBCPU_LOW, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
#ifdef JSUB
	LoadString(hAppInstance, IDS_GP_JSUBCPU, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
#endif
#endif
	(void)ComboBox_SetCurSel(hWnd, 0);

	/* CPUx */
	hWnd = GetDlgItem(hDlg, IDC_GP_CPUSPIN);
	ASSERT(hWnd);
	UpDown_SetRange(hWnd, 9999, 1);
	UpDown_SetPos(hWnd, propdat.main_speed);

	/* e[v[^tO */
	if (propdat.bTapeFull) {
		CheckDlgButton(hDlg, IDC_GP_TAPESPEED, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_GP_TAPESPEED, BST_UNCHECKED);
	}

	/* e[v[^[htO */
	if (propdat.bTapeMode) {
		CheckDlgButton(hDlg, IDC_GP_TAPESPEEDMODE, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_GP_TAPESPEEDMODE, BST_UNCHECKED);
	}
	hWnd = GetDlgItem(hDlg, IDC_GP_TAPESPEEDMODE);
	EnableWindow(hWnd, propdat.bTapeFull);

	/* S͋쓮tO */
	if (propdat.bCPUFull) {
		CheckDlgButton(hDlg, IDC_GP_FULLSPEED, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_GP_FULLSPEED, BST_UNCHECKED);
	}

	/* xtO */
	if (propdat.bSpeedAdjust) {
		CheckDlgButton(hDlg, IDC_GP_AUTOSPEEDADJUST, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_GP_AUTOSPEEDADJUST, BST_UNCHECKED);
	}

	/* FDDEFCgtO */
#ifdef FDDSND
	if (propdat.bFddWait) {
		CheckDlgButton(hDlg, IDC_GP_FDDWAIT, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_GP_FDDWAIT, BST_UNCHECKED);
	}
#endif
}

/*
 *	Sʃy[W
 *	R}h
 */
static void FASTCALL GeneralPageCmd(HWND hDlg, WORD wID, WORD wNotifyCode, HWND hWnd)
{
	int index;
	int cycles;
	HWND hSpin;
	HWND hCombo;

	ASSERT(hDlg);

	/* ID */
	switch (wID) {
		case IDC_GP_TAPESPEED:
			hWnd = GetDlgItem(hDlg, IDC_GP_TAPESPEEDMODE);
			if (IsDlgButtonChecked(hDlg, IDC_GP_TAPESPEED) == BST_CHECKED) {
				EnableWindow(hWnd, TRUE);
			}
			else {
				EnableWindow(hWnd, FALSE);
			}
			break;


		/* CPUx */
		case IDC_GP_CPUTEXT:
			if (wNotifyCode == EN_CHANGE) {
				cycles = GetDlgItemInt(hDlg, IDC_GP_CPUTEXT, 0, FALSE);
				if (cycles < 1) {
					cycles = 1;
				}
				else if (cycles > 9999) {
					cycles = 9999;
				}

				/* li[ */
				hCombo = GetDlgItem(hDlg, IDC_GP_CPUCOMBO);
				index = ComboBox_GetCurSel(hCombo);
				switch (index) {
					case 0:
						propdat.main_speed = (DWORD)cycles;
						break;
#if XM7_VER >= 2
					case 1:
						propdat.mmr_speed = (DWORD)cycles;
						break;
					case 2:
#if XM7_VER >= 3
						propdat.fmmr_speed = (DWORD)cycles;
						break;
					case 3:
#endif
						propdat.sub_speed = (DWORD)cycles;
						break;
#else
					case 1:
						propdat.main_speed_low = (DWORD)cycles;
						break;
					case 2:
						propdat.mmr_speed = (DWORD)cycles;
						break;
					case 3:
						propdat.sub_speed = (DWORD)cycles;
						break;
					case 4:
						propdat.sub_speed_low = (DWORD)cycles;
						break;
#ifdef JSUB
					case 5:
						propdat.jsub_speed = (DWORD)cycles;
						break;
#endif
#endif
					case CB_ERR:
						/* ږI */
						break;
					default:
						ASSERT(FALSE);
						break;
				}
			}
			break;

		/* CPUIR{{bNX */
		case IDC_GP_CPUCOMBO:
			/* IΏۂςAVl[h */
			if (wNotifyCode == CBN_SELCHANGE) {
				index = ComboBox_GetCurSel(hWnd);
				hSpin = GetDlgItem(hDlg, IDC_GP_CPUSPIN);
				ASSERT(hSpin);
				switch (index) {
					case 0:
						UpDown_SetPos(hSpin, propdat.main_speed);
						break;
#if XM7_VER >= 2
					case 1:
						UpDown_SetPos(hSpin, propdat.mmr_speed);
						break;
					case 2:
#if XM7_VER >= 3
						UpDown_SetPos(hSpin, propdat.fmmr_speed);
						break;
					case 3:
#endif
						UpDown_SetPos(hSpin, propdat.sub_speed);
						break;
#else
					case 1:
						UpDown_SetPos(hSpin, propdat.main_speed_low);
						break;
					case 2:
						UpDown_SetPos(hSpin, propdat.mmr_speed);
						break;
					case 3:
						UpDown_SetPos(hSpin, propdat.sub_speed);
						break;
					case 4:
						UpDown_SetPos(hSpin, propdat.sub_speed_low);
						break;
#ifdef JSUB
					case 5:
						UpDown_SetPos(hSpin, propdat.jsub_speed);
						break;
#endif
#endif
					default:
						ASSERT(FALSE);
				}
			}
			break;

		case IDC_GP_CPUDEFAULT:
			/* ftHglݒ */
			propdat.main_speed = MAINCYCLES;
			propdat.mmr_speed = MAINCYCLES_MMR;
#if XM7_VER >= 3
			propdat.fmmr_speed = MAINCYCLES_FMMR;
#endif
			propdat.sub_speed = SUBCYCLES;
#if XM7_VER == 1
			propdat.main_speed_low = MAINCYCLES_LOW;
			propdat.sub_speed_low = SUBCYCLES_LOW;
#ifdef JSUB
			propdat.jsub_speed = JSUBCYCLES;
#endif
#endif

			/* Vl[h */
			hCombo = GetDlgItem(hDlg, IDC_GP_CPUCOMBO);
			index = ComboBox_GetCurSel(hCombo);
			hSpin = GetDlgItem(hDlg, IDC_GP_CPUSPIN);
			ASSERT(hSpin);
			switch (index) {
				case 0:
					UpDown_SetPos(hSpin, propdat.main_speed);
					break;
#if XM7_VER >= 2
				case 1:
					UpDown_SetPos(hSpin, propdat.mmr_speed);
					break;
				case 2:
#if XM7_VER >= 3
					UpDown_SetPos(hSpin, propdat.fmmr_speed);
					break;
				case 3:
#endif
					UpDown_SetPos(hSpin, propdat.sub_speed);
					break;
#else
				case 1:
					UpDown_SetPos(hSpin, propdat.main_speed_low);
					break;
				case 2:
					UpDown_SetPos(hSpin, propdat.mmr_speed);
					break;
				case 3:
					UpDown_SetPos(hSpin, propdat.sub_speed);
					break;
				case 4:
					UpDown_SetPos(hSpin, propdat.sub_speed_low);
					break;
#ifdef JSUB
				case 5:
					UpDown_SetPos(hSpin, propdat.jsub_speed);
					break;
#endif
#endif
				default:
					ASSERT(FALSE);
			}
			break;
	}
}

/*
 *	Sʃy[W
 *	XN[
 */
static void FASTCALL GeneralPageVScroll(HWND hDlg, WORD wPos, HWND hWnd)
{
	int index;
	HWND hCombo;

	/* `FbN */
	if (hWnd != GetDlgItem(hDlg, IDC_GP_CPUSPIN)) {
		return;
	}

	/* li[ */
	hCombo = GetDlgItem(hDlg, IDC_GP_CPUCOMBO);
	index = ComboBox_GetCurSel(hCombo);
	switch (index) {
		case 0:
			propdat.main_speed = (DWORD)wPos;
			break;
#if XM7_VER >= 2
		case 1:
			propdat.mmr_speed = (DWORD)wPos;
			break;
		case 2:
#if XM7_VER >= 3
			propdat.fmmr_speed = (DWORD)wPos;
			break;
		case 3:
#endif
			propdat.sub_speed = (DWORD)wPos;
			break;
#else
		case 1:
			propdat.main_speed_low = (DWORD)wPos;
			break;
		case 2:
			propdat.mmr_speed = (DWORD)wPos;
			break;
		case 3:
			propdat.sub_speed = (DWORD)wPos;
			break;
		case 4:
			propdat.sub_speed_low = (DWORD)wPos;
			break;
#ifdef JSUB
		case 5:
			propdat.jsub_speed = (DWORD)wPos;
			break;
#endif
#endif
		default:
			ASSERT(FALSE);
			break;
	}
}

/*
 *	Sʃy[W
 *	Kp
 */
static void FASTCALL GeneralPageApply(HWND hDlg)
{
	/* Xe[gύX */
	uPropertyState = 2;

	/* FM-7o[W */
#if XM7_VER >= 2
	if (IsDlgButtonChecked(hDlg, IDC_GP_FM7) == BST_CHECKED) {
		propdat.fm7_ver = 1;
	}
#if XM7_VER >= 3
	else if (IsDlgButtonChecked(hDlg, IDC_GP_FM77AV) == BST_CHECKED) {
		propdat.fm7_ver = 2;
	}
	else
	{
		propdat.fm7_ver = 3;
	}
#else
	else {
		propdat.fm7_ver = 2;
	}
#endif
#else
	if (IsDlgButtonChecked(hDlg, IDC_GP_FM8) == BST_CHECKED) {
		propdat.fm_subtype = FMSUB_FM8;
	}
	else if (IsDlgButtonChecked(hDlg, IDC_GP_FM7) == BST_CHECKED) {
		propdat.fm_subtype = FMSUB_FM7;
	}
	else {
		propdat.fm_subtype = FMSUB_FM77;
	}

	/* CCPUNbN */
	if (IsDlgButtonChecked(hDlg, IDC_GP_MAIN1MHZ) == BST_CHECKED) {
		propdat.lowspeed_mode = TRUE;
	}
	else {
		propdat.lowspeed_mode = FALSE;
	}
#endif

	/* TCNX`[ */
	if (IsDlgButtonChecked(hDlg, IDC_GP_HIGHSPEED) == BST_CHECKED) {
		propdat.cycle_steal = TRUE;
		propdat.subclock_mode = FALSE;
	}
	else if (IsDlgButtonChecked(hDlg, IDC_GP_MIDSPEED) == BST_CHECKED) {
		propdat.cycle_steal = FALSE;
		propdat.subclock_mode = FALSE;
	}
	else {
		propdat.cycle_steal = FALSE;
		propdat.subclock_mode = TRUE;
	}

	/* e[v[h */
	if (IsDlgButtonChecked(hDlg, IDC_GP_TAPESPEED) == BST_CHECKED) {
		propdat.bTapeFull = TRUE;
	}
	else {
		propdat.bTapeFull = FALSE;
	}

	/* e[v[h^Cv */
	if (IsDlgButtonChecked(hDlg, IDC_GP_TAPESPEEDMODE) == BST_CHECKED) {
		propdat.bTapeMode = TRUE;
	}
	else {
		propdat.bTapeMode = FALSE;
	}

	/* S͋쓮 */
	if (IsDlgButtonChecked(hDlg, IDC_GP_FULLSPEED) == BST_CHECKED) {
		propdat.bCPUFull = TRUE;
	}
	else {
		propdat.bCPUFull = FALSE;
	}

	/* x */
	if (IsDlgButtonChecked(hDlg, IDC_GP_AUTOSPEEDADJUST) == BST_CHECKED) {
		propdat.bSpeedAdjust = TRUE;
	}
	else {
		propdat.bSpeedAdjust = FALSE;
	}

	/* FDDEFCg */
#ifdef FDDSND
	if (IsDlgButtonChecked(hDlg, IDC_GP_FDDWAIT) == BST_CHECKED) {
		propdat.bFddWait = TRUE;
	}
	else {
		propdat.bFddWait = FALSE;
	}
#endif
}

/*
 *	Sʃy[W
 *	_CAOvV[W
 */
static BOOL CALLBACK GeneralPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			GeneralPageInit(hDlg);
			return TRUE;

		/* R}h */
		case WM_COMMAND:
			GeneralPageCmd(hDlg, LOWORD(wParam), HIWORD(wParam), (HWND)lParam);
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				GeneralPageApply(hDlg);
				return TRUE;
			}
			break;

		/* XN[ */
		case WM_VSCROLL:
			GeneralPageVScroll(hDlg, HIWORD(wParam), (HWND)lParam);
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_GP_HELP);
			}
			break;
	}

	return FALSE;
}

/*-[ TEhy[W ]-------------------------------------------------------*/

/*
 *	TEhy[W
 *	R}h
 */
static void FASTCALL SoundPageCmd(HWND hDlg, WORD wID, WORD wNotifyCode, HWND hWnd)
{
	int tmp;
	HWND hSpin;

	ASSERT(hDlg);
	UNUSED(hWnd);

	/* ID */
	switch (wID) {
		/* TEhobt@ */
		case IDC_SP_BUFEDIT:
			if (wNotifyCode == EN_CHANGE) {
				tmp = GetDlgItemInt(hDlg, IDC_SP_BUFEDIT, 0, FALSE) / 10;
				if (tmp < 4) {
					tmp = 4;
				}
				else if (tmp > 100) {
					tmp = 100;
				}

				hSpin = GetDlgItem(hDlg, IDC_SP_BUFSPIN);
				ASSERT(hSpin);
				UpDown_SetPos(hSpin, tmp);
			}
			break;

		/* BEEPg */
		case IDC_SP_BEEPEDIT:
			if (wNotifyCode == EN_CHANGE) {
				tmp = GetDlgItemInt(hDlg, IDC_SP_BEEPEDIT, 0, FALSE);
				if (tmp < 100) {
					tmp = 100;
				}
				else if (tmp > 9999) {
					tmp = 9999;
				}

				hSpin = GetDlgItem(hDlg, IDC_SP_BEEPSPIN);
				ASSERT(hSpin);
				UpDown_SetPos(hSpin, tmp);
			}
			break;
		}
}

/*
 *	TEhy[W
 *	XN[
 */
static void FASTCALL SoundPageVScroll(HWND hDlg, WORD wPos, HWND hWnd)
{
	HWND hBuddyWnd;
	char string[128];

	ASSERT(hDlg);
	ASSERT(hWnd);

	/* EChEnh`FbN */
	if (hWnd == GetDlgItem(hDlg, IDC_SP_BUFSPIN)) {
		/* TEhobt@ */
		/* |WVAofBEChEɒlݒ */
		hBuddyWnd = GetDlgItem(hDlg, IDC_SP_BUFEDIT);
		ASSERT(hBuddyWnd);
		_snprintf(string, sizeof(string), "%d", wPos * 10);
		SetWindowText(hBuddyWnd, string);
	}
	else if (hWnd == GetDlgItem(hDlg, IDC_SP_BEEPSPIN)) {
		/* BEEPg */
		/* |WVAofBEChEɒlݒ */
		hBuddyWnd = GetDlgItem(hDlg, IDC_SP_BEEPEDIT);
		ASSERT(hBuddyWnd);
		_snprintf(string, sizeof(string), "%d", wPos);
		SetWindowText(hBuddyWnd, string);
	}
}

/*
 *	TEhy[W
 *	_CAO
 */
static void FASTCALL SoundPageInit(HWND hDlg)
{
	HWND hWnd;
	char string[128];

	/* V[g */
	SheetInit(hDlg);

	/* TvO[g */
	switch (propdat.nSampleRate) {
		case 96000:
			CheckDlgButton(hDlg, IDC_SP_96K, BST_CHECKED);
			break;
		case 88200:
			CheckDlgButton(hDlg, IDC_SP_88K, BST_CHECKED);
			break;
		case 51200:
			CheckDlgButton(hDlg, IDC_SP_51K, BST_CHECKED);
			break;
		case 48000:
			CheckDlgButton(hDlg, IDC_SP_48K, BST_CHECKED);
			break;
		case 44100:
			CheckDlgButton(hDlg, IDC_SP_44K, BST_CHECKED);
			break;
		case 25600:
			CheckDlgButton(hDlg, IDC_SP_25K, BST_CHECKED);
			break;
		case 22050:
			CheckDlgButton(hDlg, IDC_SP_22K, BST_CHECKED);
			break;
		case 0:
			CheckDlgButton(hDlg, IDC_SP_NONE, BST_CHECKED);
			break;
		default:
			ASSERT(FALSE);
			break;
	}

	/* TEhobt@ */
	hWnd = GetDlgItem(hDlg, IDC_SP_BUFSPIN);
	ASSERT(hWnd);
	UpDown_SetRange(hWnd, 100, 4);
	UpDown_SetPos(hWnd, propdat.nSoundBuffer / 10);
	SoundPageVScroll(hDlg, LOWORD(UpDown_GetPos(hWnd)), hWnd);

	/* BEEPg */
	hWnd = GetDlgItem(hDlg, IDC_SP_BEEPSPIN);
	ASSERT(hWnd);
	UpDown_SetRange(hWnd, 9999, 100);
	UpDown_SetPos(hWnd, propdat.nBeepFreq);
	SoundPageVScroll(hDlg, LOWORD(UpDown_GetPos(hWnd)), hWnd);

	/* FMi[h */
	if (propdat.bInterpolation) {
		CheckDlgButton(hDlg, IDC_SP_HQMODE, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SP_HQMODE, BST_UNCHECKED);
	}

	/* o̓[h */
	hWnd = GetDlgItem(hDlg, IDC_SP_STEREO);
	ASSERT(hWnd);
	string[0] = '\0';
	(void)ComboBox_ResetContent(hWnd);
	LoadString(hAppInstance, IDS_SP_MONO, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_SP_STEREO, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_SP_STEREO_WHGREV, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_SP_STEREO_THG, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_SP_STEREO_THGREV, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	(void)ComboBox_SetCurSel(hWnd, propdat.uStereoOut);

	/* e[vj^ */
	if (propdat.bTapeMon) {
		CheckDlgButton(hDlg, IDC_SP_TAPEMON, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SP_TAPEMON, BST_UNCHECKED);
	}

	/* ݂ */
#ifdef ROMEO
	if (propdat.bUseRomeo) {
		CheckDlgButton(hDlg, IDC_SP_ROMEO, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SP_ROMEO, BST_UNCHECKED);
	}
	if (!bRomeo) {
		hWnd = GetDlgItem(hDlg, IDC_SP_ROMEO);
		EnableWindow(hWnd, FALSE);
	}
#endif

	/* SCCI */
#ifdef SCCI
	if (propdat.bUseSCCI) {
		CheckDlgButton(hDlg, IDC_SP_SCCI, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SP_SCCI, BST_UNCHECKED);
	}
	if (!bSCCI_available) {
		hWnd = GetDlgItem(hDlg, IDC_SP_SCCI);
		EnableWindow(hWnd, FALSE);
	}
#endif

	/* FDDV[N */
#ifdef FDDSND
	if (propdat.bFddSound) {
		CheckDlgButton(hDlg, IDC_SP_FDDSOUND, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SP_FDDSOUND, BST_UNCHECKED);
	}
#endif
}

/*
 *	TEhy[W
 *	Kp
 */
static void FASTCALL SoundPageApply(HWND hDlg)
{
	HWND hWnd;
	UINT uPos;

	/* Xe[gύX */
	uPropertyState = 2;

	/* TvO[g */
	if (IsDlgButtonChecked(hDlg, IDC_SP_96K) == BST_CHECKED) {
		propdat.nSampleRate = 96000;
	}
	if (IsDlgButtonChecked(hDlg, IDC_SP_88K) == BST_CHECKED) {
		propdat.nSampleRate = 88200;
	}
	if (IsDlgButtonChecked(hDlg, IDC_SP_51K) == BST_CHECKED) {
		propdat.nSampleRate = 51200;
	}
	if (IsDlgButtonChecked(hDlg, IDC_SP_48K) == BST_CHECKED) {
		propdat.nSampleRate = 48000;
	}
	if (IsDlgButtonChecked(hDlg, IDC_SP_44K) == BST_CHECKED) {
		propdat.nSampleRate = 44100;
	}
	if (IsDlgButtonChecked(hDlg, IDC_SP_25K) == BST_CHECKED) {
		propdat.nSampleRate = 25600;
	}
	if (IsDlgButtonChecked(hDlg, IDC_SP_22K) == BST_CHECKED) {
		propdat.nSampleRate = 22050;
	}
	if (IsDlgButtonChecked(hDlg, IDC_SP_NONE) == BST_CHECKED) {
		propdat.nSampleRate = 0;
	}

	/* TEhobt@ */
	hWnd = GetDlgItem(hDlg, IDC_SP_BUFSPIN);
	ASSERT(hWnd);
	uPos = LOWORD(UpDown_GetPos(hWnd));
	propdat.nSoundBuffer = uPos * 10;

	/* BEEPg */
	hWnd = GetDlgItem(hDlg, IDC_SP_BEEPSPIN);
	ASSERT(hWnd);
	propdat.nBeepFreq = LOWORD(UpDown_GetPos(hWnd));

	/* FMi[h */
	if (IsDlgButtonChecked(hDlg, IDC_SP_HQMODE) == BST_CHECKED) {
		propdat.bInterpolation = TRUE;
	}
	else {
		propdat.bInterpolation = FALSE;
	}

	/* o̓[h */
	hWnd = GetDlgItem(hDlg, IDC_SP_STEREO);
	propdat.uStereoOut = ComboBox_GetCurSel(hWnd);

	/* e[vj^ */
	if (IsDlgButtonChecked(hDlg, IDC_SP_TAPEMON) == BST_CHECKED) {
		propdat.bTapeMon = TRUE;
	}
	else {
		propdat.bTapeMon = FALSE;
	}

	/* ݂ */
#ifdef ROMEO
	if ((IsDlgButtonChecked(hDlg, IDC_SP_ROMEO) == BST_CHECKED) && bRomeo) {
		propdat.bUseRomeo = TRUE;
	}
	else {
		propdat.bUseRomeo = FALSE;
	}
#endif

	/* SCCI */
#ifdef SCCI
	if ((IsDlgButtonChecked(hDlg, IDC_SP_SCCI) == BST_CHECKED) &&
		bSCCI_available) {
		propdat.bUseSCCI = TRUE;
	}
	else {
		propdat.bUseSCCI = FALSE;
	}
#endif

	/* FDDV[N */
#ifdef FDDSND
	if (IsDlgButtonChecked(hDlg, IDC_SP_FDDSOUND) == BST_CHECKED) {
		propdat.bFddSound = TRUE;
	}
	else {
		propdat.bFddSound = FALSE;
	}
#endif
}

/*
 *	TEhy[W
 *	_CAOvV[W
 */
static BOOL CALLBACK SoundPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			SoundPageInit(hDlg);
			return TRUE;

		/* R}h */
		case WM_COMMAND:
			SoundPageCmd(hDlg, LOWORD(wParam), HIWORD(wParam), (HWND)lParam);
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				SoundPageApply(hDlg);
				return TRUE;
			}
			break;

		/* XN[ */
		case WM_VSCROLL:
			SoundPageVScroll(hDlg, HIWORD(wParam), (HWND)lParam);
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_SP_HELP);
			}
			break;
	}

	return FALSE;
}

/*-[ ʒy[W ]-------------------------------------------------------*/

/*
 *	ʒy[W
 *	XC_[Abvf[g
 */
static void FASTCALL UpdateVolumeSlider(HWND hDlg)
{
	UINT uSp;
	int nFM;
	int nPSG;
	int nBeep;
	int nCMT;
	int nWav;
	char string[128];

	/* eGfBbg{bNXɃXC_[̒lݒ */
	uSp = SendDlgItemMessage(hDlg, IDC_VP_SEPARATION, TBM_GETPOS, 0, 0);
	_snprintf(string, sizeof(string), "%u", uSp);
	Edit_SetText(GetDlgItem(hDlg, IDC_VP_SEPARATIONTEXT), string);
	nFM = SendDlgItemMessage(hDlg, IDC_VP_FMVOLUME, TBM_GETPOS, 0, 0);
	_snprintf(string, sizeof(string), "%d", nFM);
	Edit_SetText(GetDlgItem(hDlg, IDC_VP_FMVOLUMETEXT), string);
	nPSG = SendDlgItemMessage(hDlg, IDC_VP_PSGVOLUME, TBM_GETPOS, 0, 0);
	_snprintf(string, sizeof(string), "%d", nPSG);
	Edit_SetText(GetDlgItem(hDlg, IDC_VP_PSGVOLUMETEXT), string);
	nBeep = SendDlgItemMessage(hDlg, IDC_VP_BEEPVOLUME, TBM_GETPOS, 0, 0);
	_snprintf(string, sizeof(string), "%d", nBeep);
	Edit_SetText(GetDlgItem(hDlg, IDC_VP_BEEPVOLUMETEXT), string);
	nCMT = SendDlgItemMessage(hDlg, IDC_VP_CMTVOLUME, TBM_GETPOS, 0, 0);
	_snprintf(string, sizeof(string), "%d", nCMT);
	Edit_SetText(GetDlgItem(hDlg, IDC_VP_CMTVOLUMETEXT), string);
#ifdef FDDSND
	nWav = SendDlgItemMessage(hDlg, IDC_VP_WAVEVOLUME, TBM_GETPOS, 0, 0);
	_snprintf(string, sizeof(string), "%d", nWav);
	Edit_SetText(GetDlgItem(hDlg, IDC_VP_WAVEVOLUMETEXT), string);
#else
	nWav = 0;
#endif

	/* {[ݒ */
	SetSoundVolume2(uSp, nFM, nPSG, nBeep, nCMT, nWav);
}

/*
 *	ʒy[W
 *	_CAO
 */
static void FASTCALL VolumePageInit(HWND hDlg)
{
	ASSERT(hDlg);

	/* V[g */
	SheetInit(hDlg);

	/* `lZp[V */
	SendDlgItemMessage(hDlg, IDC_VP_SEPARATION, TBM_SETLINESIZE, 0, 1);
	SendDlgItemMessage(hDlg, IDC_VP_SEPARATION, TBM_SETPAGESIZE, 0, 4);
	SendDlgItemMessage(hDlg, IDC_VP_SEPARATION, TBM_SETRANGE, TRUE,
		MAKELONG(0, 16));
	SendDlgItemMessage(hDlg, IDC_VP_SEPARATION, TBM_SETPOS, TRUE,
		propdat.uChSeparation);

	/* FM */
	SendDlgItemMessage(hDlg, IDC_VP_FMVOLUME, TBM_SETLINESIZE, 0, 1);
	SendDlgItemMessage(hDlg, IDC_VP_FMVOLUME, TBM_SETPAGESIZE, 0, 6);
	SendDlgItemMessage(hDlg, IDC_VP_FMVOLUME, TBM_SETRANGE, TRUE,
		MAKELONG(-96, 20));
	SendDlgItemMessage(hDlg, IDC_VP_FMVOLUME, TBM_SETPOS, TRUE,
		propdat.nFMVolume);

	/* PSG */
	SendDlgItemMessage(hDlg, IDC_VP_PSGVOLUME, TBM_SETLINESIZE, 0, 1);
	SendDlgItemMessage(hDlg, IDC_VP_PSGVOLUME, TBM_SETPAGESIZE, 0, 6);
	SendDlgItemMessage(hDlg, IDC_VP_PSGVOLUME, TBM_SETRANGE, TRUE,
		MAKELONG(-96, 20));
	SendDlgItemMessage(hDlg, IDC_VP_PSGVOLUME, TBM_SETPOS, TRUE,
		propdat.nPSGVolume);

	/* BEEP */
	SendDlgItemMessage(hDlg, IDC_VP_BEEPVOLUME, TBM_SETLINESIZE, 0, 1);
	SendDlgItemMessage(hDlg, IDC_VP_BEEPVOLUME, TBM_SETPAGESIZE, 0, 6);
	SendDlgItemMessage(hDlg, IDC_VP_BEEPVOLUME, TBM_SETRANGE, TRUE,
		MAKELONG(-96, 0));
	SendDlgItemMessage(hDlg, IDC_VP_BEEPVOLUME, TBM_SETPOS, TRUE,
		propdat.nBeepVolume);

	/* CMTj^ */
	SendDlgItemMessage(hDlg, IDC_VP_CMTVOLUME, TBM_SETLINESIZE, 0, 1);
	SendDlgItemMessage(hDlg, IDC_VP_CMTVOLUME, TBM_SETPAGESIZE, 0, 6);
	SendDlgItemMessage(hDlg, IDC_VP_CMTVOLUME, TBM_SETRANGE, TRUE,
		MAKELONG(-96, 0));
	SendDlgItemMessage(hDlg, IDC_VP_CMTVOLUME, TBM_SETPOS, TRUE,
		propdat.nCMTVolume);

	/* eʉ */
#ifdef FDDSND
	SendDlgItemMessage(hDlg, IDC_VP_WAVEVOLUME, TBM_SETLINESIZE, 0, 1);
	SendDlgItemMessage(hDlg, IDC_VP_WAVEVOLUME, TBM_SETPAGESIZE, 0, 6);
	SendDlgItemMessage(hDlg, IDC_VP_WAVEVOLUME, TBM_SETRANGE, TRUE,
		MAKELONG(-96, 0));
	SendDlgItemMessage(hDlg, IDC_VP_WAVEVOLUME, TBM_SETPOS, TRUE,
		propdat.nWaveVolume);
#endif

	/* XC_[Abvf[g */
	UpdateVolumeSlider(hDlg);
}

/*
 *	ʒy[W
 *	Kp
 */
static void FASTCALL VolumePageApply(HWND hDlg)
{
	/* Xe[gύX */
	uPropertyState = 2;

	/* `lZp[V */
	propdat.uChSeparation = SendDlgItemMessage(hDlg, IDC_VP_SEPARATION,
		TBM_GETPOS, 0, 0);

	/* FM */
	propdat.nFMVolume = SendDlgItemMessage(hDlg, IDC_VP_FMVOLUME,
		TBM_GETPOS, 0, 0);

	/* PSG */
	propdat.nPSGVolume = SendDlgItemMessage(hDlg, IDC_VP_PSGVOLUME,
		TBM_GETPOS, 0, 0);

	/* BEEP */
	propdat.nBeepVolume = SendDlgItemMessage(hDlg, IDC_VP_BEEPVOLUME,
		TBM_GETPOS, 0, 0);

	/* CMTj^ */
	propdat.nCMTVolume = SendDlgItemMessage(hDlg, IDC_VP_CMTVOLUME,
		TBM_GETPOS, 0, 0);

	/* eʉ */
#ifdef FDDSND
	propdat.nWaveVolume = SendDlgItemMessage(hDlg, IDC_VP_WAVEVOLUME,
		TBM_GETPOS, 0, 0);
#endif
}

/*
 *	ʒy[W
 *	_CAOvV[W
 */
static BOOL CALLBACK VolumePageProc(HWND hDlg, UINT msg,
									WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	switch (msg) {
		/* _CAO */
		case WM_INITDIALOG:
			VolumePageInit(hDlg);
			return TRUE;

		/* R}h */
		case WM_COMMAND:
			if (LOWORD(wParam) == IDC_VP_DEFAULT) {
				SendDlgItemMessage(hDlg, IDC_VP_SEPARATION, TBM_SETPOS,
					TRUE, CHSEPARATION_DEFAULT);
				SendDlgItemMessage(hDlg, IDC_VP_FMVOLUME, TBM_SETPOS,
					TRUE, FMVOLUME_DEFAULT);
				SendDlgItemMessage(hDlg, IDC_VP_PSGVOLUME, TBM_SETPOS,
					TRUE, PSGVOLUME_DEFAULT);
				SendDlgItemMessage(hDlg, IDC_VP_BEEPVOLUME, TBM_SETPOS,
					TRUE, BEEPVOLUME_DEFAULT);
				SendDlgItemMessage(hDlg, IDC_VP_CMTVOLUME, TBM_SETPOS,
					TRUE, CMTVOLUME_DEFAULT);
#ifdef FDDSND
				SendDlgItemMessage(hDlg, IDC_VP_WAVEVOLUME, TBM_SETPOS,
					TRUE, WAVEVOLUME_DEFAULT);
#endif
				UpdateVolumeSlider(hDlg);
				return TRUE;
			}
			break;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				VolumePageApply(hDlg);
				return TRUE;
			}
			if (pnmh->code == PSN_QUERYCANCEL) {
				SetSoundVolume();
				return TRUE;
			}
			break;

		/* cXN[ */
		case WM_HSCROLL:
			UpdateVolumeSlider(hDlg);
			return FALSE;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_VP_HELP);
			}
			break;
		}

	/* ȊOFALSE */
	return FALSE;
}

/*-[ L[̓_CAO ]---------------------------------------------------*/

/*
 *	L[{[hy[W
 *	DirectInput L[R[he[u
 */
static char *KbdPageDirectInput[] = {
	NULL,					/* 0x00 */
	"DIK_ESCAPE",			/* 0x01 */
	"DIK_1",				/* 0x02 */
	"DIK_2",				/* 0x03 */
	"DIK_3",				/* 0x04 */
	"DIK_4",				/* 0x05 */
	"DIK_5",				/* 0x06 */
	"DIK_6",				/* 0x07 */
	"DIK_7",				/* 0x08 */
	"DIK_8",				/* 0x09 */
	"DIK_9",				/* 0x0A */
	"DIK_0",				/* 0x0B */
	"DIK_MINUS",			/* 0x0C */
	"DIK_EQUALS",			/* 0x0D */
	"DIK_BACK",				/* 0x0E */
	"DIK_TAB",				/* 0x0F */
	"DIK_Q",				/* 0x10 */
	"DIK_W",				/* 0x11 */
	"DIK_E",				/* 0x12 */
	"DIK_R",				/* 0x13 */
	"DIK_T",				/* 0x14 */
	"DIK_Y",				/* 0x15 */
	"DIK_U",				/* 0x16 */
	"DIK_I",				/* 0x17 */
	"DIK_O",				/* 0x18 */
	"DIK_P",				/* 0x19 */
	"DIK_LBRACKET",			/* 0x1A */
	"DIK_RBRACKET",			/* 0x1B */
	"DIK_RETURN",			/* 0x1C */
	"DIK_LCONTROL",			/* 0x1D */
	"DIK_A",				/* 0x1E */
	"DIK_S",				/* 0x1F */
	"DIK_D",				/* 0x20 */
	"DIK_F",				/* 0x21 */
	"DIK_G",				/* 0x22 */
	"DIK_H",				/* 0x23 */
	"DIK_J",				/* 0x24 */
	"DIK_K",				/* 0x25 */
	"DIK_L",				/* 0x26 */
	"DIK_SEMICOLON",		/* 0x27 */
	"DIK_APOSTROPHE",		/* 0x28 */
	"DIK_GRAVE",			/* 0x29 */
	"DIK_LSHIFT",			/* 0x2A */
	"DIK_BACKSLASH",		/* 0x2B */
	"DIK_Z",				/* 0x2C */
	"DIK_X",				/* 0x2D */
	"DIK_C",				/* 0x2E */
	"DIK_V",				/* 0x2F */
	"DIK_B",				/* 0x30 */
	"DIK_N",				/* 0x31 */
	"DIK_M",				/* 0x32 */
	"DIK_COMMA",			/* 0x33 */
	"DIK_PERIOD",			/* 0x34 */
	"DIK_SLASH",			/* 0x35 */
	"DIK_RSHIFT",			/* 0x36 */
	"DIK_MULTIPLY",			/* 0x37 */
	"DIK_LMENU",			/* 0x38 */
	"DIK_SPACE",			/* 0x39 */
	"DIK_CAPITAL",			/* 0x3A */
	"DIK_F1",				/* 0x3B */
	"DIK_F2",				/* 0x3C */
	"DIK_F3",				/* 0x3D */
	"DIK_F4",				/* 0x3E */
	"DIK_F5",				/* 0x3F */
	"DIK_F6",				/* 0x40 */
	"DIK_F7",				/* 0x41 */
	"DIK_F8",				/* 0x42 */
	"DIK_F9",				/* 0x43 */
	"DIK_F10",				/* 0x44 */
	"DIK_NUMLOCK",			/* 0x45 */
	"DIK_SCROLL",			/* 0x46 */
	"DIK_NUMPAD7",			/* 0x47 */
	"DIK_NUMPAD8",			/* 0x48 */
	"DIK_NUMPAD9",			/* 0x49 */
	"DIK_SUBTRACT",			/* 0x4A */
	"DIK_NUMPAD4",			/* 0x4B */
	"DIK_NUMPAD5",			/* 0x4C */
	"DIK_NUMPAD6",			/* 0x4D */
	"DIK_ADD",				/* 0x4E */
	"DIK_NUMPAD1",			/* 0x4F */
	"DIK_NUMPAD2",			/* 0x50 */
	"DIK_NUMPAD3",			/* 0x51 */
	"DIK_NUMPAD0",			/* 0x52 */
	"DIK_DECIMAL",			/* 0x53 */
	NULL,					/* 0x54 */
	NULL,					/* 0x55 */
	"DIK_OEM_102",			/* 0x56 */
	"DIK_F11",				/* 0x57 */
	"DIK_F12",				/* 0x58 */
	NULL,					/* 0x59 */
	NULL,					/* 0x5A */
	NULL,					/* 0x5B */
	NULL,					/* 0x5C */
	NULL,					/* 0x5D */
	NULL,					/* 0x5E */
	NULL,					/* 0x5F */
	NULL,					/* 0x60 */
	NULL,					/* 0x61 */
	NULL,					/* 0x62 */
	NULL,					/* 0x63 */
	"DIK_F13",				/* 0x64 */
	"DIK_F14",				/* 0x65 */
	"DIK_F15",				/* 0x66 */
	NULL,					/* 0x67 */
	NULL,					/* 0x68 */
	NULL,					/* 0x69 */
	NULL,					/* 0x6A */
	NULL,					/* 0x6B */
	NULL,					/* 0x6C */
	NULL,					/* 0x6D */
	NULL,					/* 0x6E */
	NULL,					/* 0x6F */
	"DIK_KANA",				/* 0x70 */
	NULL,					/* 0x71 */
	NULL,					/* 0x72 */
	"DIK_ABNT_C1",			/* 0x73 */
	NULL,					/* 0x74 */
	NULL,					/* 0x75 */
	NULL,					/* 0x76 */
	NULL,					/* 0x77 */
	NULL,					/* 0x78 */
	"DIK_CONVERT",			/* 0x79 */
	NULL,					/* 0x7A */
	"DIK_NOCONVERT",		/* 0x7B */
	NULL,					/* 0x7C */
	"DIK_YEN",				/* 0x7D */
	"DIK_ABNT_C2",			/* 0x7E */
	NULL,					/* 0x7F */
	NULL,					/* 0x80 */
	NULL,					/* 0x81 */
	NULL,					/* 0x82 */
	NULL,					/* 0x83 */
	NULL,					/* 0x84 */
	NULL,					/* 0x85 */
	NULL,					/* 0x86 */
	NULL,					/* 0x87 */
	NULL,					/* 0x88 */
	NULL,					/* 0x89 */
	NULL,					/* 0x8A */
	NULL,					/* 0x8B */
	NULL,					/* 0x8C */
	"DIK_NUMPADEQUALS",		/* 0x8D */
	NULL,					/* 0x8E */
	NULL,					/* 0x8F */
	"DIK_PREVTRACK",		/* 0x90 */
	"DIK_AT",				/* 0x91 */
	"DIK_COLON",			/* 0x92 */
	"DIK_UNDERLINE",		/* 0x93 */
	"DIK_KANJI",			/* 0x94 */
	"DIK_STOP",				/* 0x95 */
	"DIK_AX",				/* 0x96 */
	"DIK_UNLABELED",		/* 0x97 */
	NULL,					/* 0x98 */
	"DIK_NEXTTRACK",		/* 0x99 */
	NULL,					/* 0x9A */
	NULL,					/* 0x9B */
	"DIK_NUMPADENTER",		/* 0x9C */
	"DIK_RCONTROL",			/* 0x9D */
	NULL,					/* 0x9E */
	NULL,					/* 0x9F */
	"DIK_MUTE",				/* 0xA0 */
	"DIK_CALCULATOR",		/* 0xA1 */
	"DIK_PLAYPAUSE",		/* 0xA2 */
	NULL,					/* 0xA3 */
	"DIK_MEDIASTOP",		/* 0xA4 */
	NULL,					/* 0xA5 */
	NULL,					/* 0xA6 */
	NULL,					/* 0xA7 */
	NULL,					/* 0xA8 */
	NULL,					/* 0xA9 */
	NULL,					/* 0xAA */
	NULL,					/* 0xAB */
	NULL,					/* 0xAC */
	NULL,					/* 0xAD */
	"DIK_VOLUMEDOWN",		/* 0xAE */
	NULL,					/* 0xAF */
	"DIK_VOLUMEUP",			/* 0xB0 */
	NULL,					/* 0xB1 */
	"DIK_WEBHOME",			/* 0xB2 */
	"DIK_NUMPADCOMMA",		/* 0xB3 */
	NULL,					/* 0xB4 */
	"DIK_DIVIDE",			/* 0xB5 */
	NULL,					/* 0xB6 */
	"DIK_SYSRQ",			/* 0xB7 */
	"DIK_RMENU",			/* 0xB8 */
	NULL,					/* 0xB9 */
	NULL,					/* 0xBA */
	NULL,					/* 0xBB */
	NULL,					/* 0xBC */
	NULL,					/* 0xBD */
	NULL,					/* 0xBE */
	NULL,					/* 0xBF */
	NULL,					/* 0xC0 */
	NULL,					/* 0xC1 */
	NULL,					/* 0xC2 */
	NULL,					/* 0xC3 */
	NULL,					/* 0xC4 */
	"DIK_PAUSE",			/* 0xC5 */
	NULL,					/* 0xC6 */
	"DIK_HOME",				/* 0xC7 */
	"DIK_UP",				/* 0xC8 */
	"DIK_PRIOR",			/* 0xC9 */
	NULL,					/* 0xCA */
	"DIK_LEFT",				/* 0xCB */
	NULL,					/* 0xCC */
	"DIK_RIGHT",			/* 0xCD */
	NULL,					/* 0xCE */
	"DIK_END",				/* 0xCF */
	"DIK_DOWN",				/* 0xD0 */
	"DIK_NEXT",				/* 0xD1 */
	"DIK_INSERT",			/* 0xD2 */
	"DIK_DELETE",			/* 0xD3 */
	NULL,					/* 0xD4 */
	NULL,					/* 0xD5 */
	NULL,					/* 0xD6 */
	NULL,					/* 0xD7 */
	NULL,					/* 0xD8 */
	NULL,					/* 0xD9 */
	NULL,					/* 0xDA */
	"DIK_LWIN",				/* 0xDB */
	"DIK_RWIN",				/* 0xDC */
	"DIK_APPS",				/* 0xDD */
	"DIK_POWER",			/* 0xDE */
	"DIK_SLEEP",			/* 0xDF */
	NULL,					/* 0xE0 */
	NULL,					/* 0xE1 */
	NULL,					/* 0xE2 */
	"DIK_WAKE",				/* 0xE3 */
	NULL,					/* 0xE4 */
	"DIK_WEBSEARCH",		/* 0xE5 */
	"DIK_WEBFAVORITES",		/* 0xE6 */
	"DIK_WEBREFRESH",		/* 0xE7 */
	"DIK_WEBSTOP",			/* 0xE8 */
	"DIK_WEBFORWARD",		/* 0xE9 */
	"DIK_WEBBACK",			/* 0xEA */
	"DIK_MYCOMPUTER",		/* 0xEB */
	"DIK_MAIL",				/* 0xEC */
	"DIK_MEDIASELECT",		/* 0xED */
	NULL,					/* 0xEE */
	NULL,					/* 0xEF */
	NULL,					/* 0xF0 */
	NULL,					/* 0xF1 */
	NULL,					/* 0xF2 */
	NULL,					/* 0xF3 */
	NULL,					/* 0xF4 */
	NULL,					/* 0xF5 */
	NULL,					/* 0xF6 */
	NULL,					/* 0xF7 */
	NULL,					/* 0xF8 */
	NULL,					/* 0xF9 */
	NULL,					/* 0xFA */
	NULL,					/* 0xFB */
	NULL,					/* 0xFC */
	NULL,					/* 0xFD */
	NULL,					/* 0xFE */
	NULL					/* 0xFF */
};

/*
 *	L[{[hy[W
 *	FM77AV L[R[he[u
 */
#if XM7_VER >= 2
static char *KbdPageFM77AV[] = {
	NULL, NULL,				/* 0x00 */
	"ESC", NULL,			/* 0x01 */
	"1", "",				/* 0x02 */
	"2", "",				/* 0x03 */
	"3", "",				/* 0x04 */
	"4", "",				/* 0x05 */
	"5", "",				/* 0x06 */
	"6", "",				/* 0x07 */
	"7", "",				/* 0x08 */
	"8", "",				/* 0x09 */
	"9", "",				/* 0x0A */
	"0", "",				/* 0x0B */
	"-", "",				/* 0x0C */
	"^", "",				/* 0x0D */
	"\\", "[",				/* 0x0E */
	"BS", NULL,				/* 0x0F */
	"TAB", NULL,			/* 0x10 */
	"Q", "",				/* 0x11 */
	"W", "",				/* 0x12 */
	"E", "",				/* 0x13 */
	"R", "",				/* 0x14 */
	"T", "",				/* 0x15 */
	"Y", "",				/* 0x16 */
	"U", "",				/* 0x17 */
	"I", "",				/* 0x18 */
	"O", "",				/* 0x19 */
	"P", "",				/* 0x1A */
	"@", "J",				/* 0x1B */
	"[", "K",				/* 0x1C */
	"RETURN", NULL,			/* 0x1D */
	"A", "",				/* 0x1E */
	"S", "",				/* 0x1F */
	"D", "",				/* 0x20 */
	"F", "",				/* 0x21 */
	"G", "",				/* 0x22 */
	"H", "",				/* 0x23 */
	"J", "",				/* 0x24 */
	"K", "",				/* 0x25 */
	"L", "",				/* 0x26 */
	";", "",				/* 0x27 */
	":", "",				/* 0x28 */
	"]", "",				/* 0x29 */
	"Z", "",				/* 0x2A */
	"X", "",				/* 0x2B */
	"C", "",				/* 0x2C */
	"V", "",				/* 0x2D */
	"B", "",				/* 0x2E */
	"N", "",				/* 0x2F */
	"M", "",				/* 0x30 */
	",", "",				/* 0x31 */
	".", "",				/* 0x32 */
	"/", "",				/* 0x33 */
	"_", "",				/* 0x34 */
	"SPACE(E)", NULL,		/* 0x35 */
	"*", "eL[",		/* 0x36 */
	"/", "eL[",		/* 0x37 */
	"+", "eL[",		/* 0x38 */
	"-", "eL[",		/* 0x39 */
	"7", "eL[",		/* 0x3A */
	"8", "eL[",		/* 0x3B */
	"9", "eL[",		/* 0x3C */
	"=", "eL[",		/* 0x3D */
	"4", "eL[",		/* 0x3E */
	"5", "eL[",		/* 0x3F */
	"6", "eL[",		/* 0x40 */
	",", "eL[",		/* 0x41 */
	"1", "eL[",		/* 0x42 */
	"2", "eL[",		/* 0x43 */
	"3", "eL[",		/* 0x44 */
	"RETURN", "eL[",	/* 0x45 */
	"0", "eL[",		/* 0x46 */
	".", "eL[",		/* 0x47 */
	"INS", NULL,			/* 0x48 */
	"EL", NULL,				/* 0x49 */
	"CLS", NULL,			/* 0x4A */
	"DEL", NULL,			/* 0x4B */
	"DUP", NULL,			/* 0x4C */
	"", NULL,				/* 0x4D */
	"HOME", NULL,			/* 0x4E */
	"", NULL,				/* 0x4F */
	"", NULL,				/* 0x50 */
	"", NULL,				/* 0x51 */
	"CTRL", NULL,			/* 0x52 */
	"SHIFT()", NULL,		/* 0x53 */
	"SHIFT(E)", NULL,		/* 0x54 */
	"CAP", NULL,			/* 0x55 */
	"GRAPH", NULL,			/* 0x56 */
	"SPACE()", NULL,		/* 0x57 */
	"SPACE()", NULL,		/* 0x58 */
	NULL, NULL,				/* 0x59 */
	"", NULL,			/* 0x5A */
	NULL, NULL,				/* 0x5B */
	"BREAK", NULL,			/* 0x5C */
	"PF1",	NULL,			/* 0x5D */
	"PF2",	NULL,			/* 0x5E */
	"PF3",	NULL,			/* 0x5F */
	"PF4",	NULL,			/* 0x60 */
	"PF5",	NULL,			/* 0x61 */
	"PF6",	NULL,			/* 0x62 */
	"PF7",	NULL,			/* 0x63 */
	"PF8",	NULL,			/* 0x64 */
	"PF9",	NULL,			/* 0x65 */
	"PF10",	NULL			/* 0x66 */
};
#else
static char *KbdPageFM77AV[] = {
	NULL, NULL,				/* 0x00 */
	"ESC", NULL,			/* 0x01 */
	"1", "k",				/* 0x02 */
	"2", "t",				/* 0x03 */
	"3", "A",				/* 0x04 */
	"4", "E",				/* 0x05 */
	"5", "G",				/* 0x06 */
	"6", "I",				/* 0x07 */
	"7", "",				/* 0x08 */
	"8", "",				/* 0x09 */
	"9", "",				/* 0x0A */
	"0", "",				/* 0x0B */
	"-", "z",				/* 0x0C */
	"^", "w",				/* 0x0D */
	"\\", "[",				/* 0x0E */
	"BS", NULL,				/* 0x0F */
	"TAB", NULL,			/* 0x10 */
	"Q", "^",				/* 0x11 */
	"W", "e",				/* 0x12 */
	"E", "C",				/* 0x13 */
	"R", "X",				/* 0x14 */
	"T", "J",				/* 0x15 */
	"Y", "",				/* 0x16 */
	"U", "i",				/* 0x17 */
	"I", "j",				/* 0x18 */
	"O", "",				/* 0x19 */
	"P", "Z",				/* 0x1A */
	"@", "J",				/* 0x1B */
	"[", "K",				/* 0x1C */
	"RETURN", NULL,			/* 0x1D */
	"A", "`",				/* 0x1E */
	"S", "g",				/* 0x1F */
	"D", "V",				/* 0x20 */
	"F", "n",				/* 0x21 */
	"G", "L",				/* 0x22 */
	"H", "N",				/* 0x23 */
	"J", "}",				/* 0x24 */
	"K", "m",				/* 0x25 */
	"L", "",				/* 0x26 */
	";", "",				/* 0x27 */
	":", "P",				/* 0x28 */
	"]", "",				/* 0x29 */
	"Z", "c",				/* 0x2A */
	"X", "T",				/* 0x2B */
	"C", "\",				/* 0x2C */
	"V", "q",				/* 0x2D */
	"B", "R",				/* 0x2E */
	"N", "~",				/* 0x2F */
	"M", "",				/* 0x30 */
	",", "l",				/* 0x31 */
	".", "",				/* 0x32 */
	"/", "",				/* 0x33 */
	"_", "",				/* 0x34 */
	"SPACE", NULL,			/* 0x35 */
	"*", "eL[",		/* 0x36 */
	"/", "eL[",		/* 0x37 */
	"+", "eL[",		/* 0x38 */
	"-", "eL[",		/* 0x39 */
	"7", "eL[",		/* 0x3A */
	"8", "eL[",		/* 0x3B */
	"9", "eL[",		/* 0x3C */
	"=", "eL[",		/* 0x3D */
	"4", "eL[",		/* 0x3E */
	"5", "eL[",		/* 0x3F */
	"6", "eL[",		/* 0x40 */
	",", "eL[",		/* 0x41 */
	"1", "eL[",		/* 0x42 */
	"2", "eL[",		/* 0x43 */
	"3", "eL[",		/* 0x44 */
	"RETURN", "eL[",	/* 0x45 */
	"0", "eL[",		/* 0x46 */
	".", "eL[",		/* 0x47 */
	"INS", NULL,			/* 0x48 */
	"EL", NULL,				/* 0x49 */
	"CLS", "(CLEAR)",		/* 0x4A */
	"DEL", NULL,			/* 0x4B */
	"DUP", NULL,			/* 0x4C */
	"", NULL,				/* 0x4D */
	"HOME", NULL,			/* 0x4E */
	"", NULL,				/* 0x4F */
	"", NULL,				/* 0x50 */
	"", NULL,				/* 0x51 */
	"CTRL", NULL,			/* 0x52 */
	"SHIFT()", NULL,		/* 0x53 */
	"SHIFT(E)", NULL,		/* 0x54 */
	"CAP", NULL,			/* 0x55 */
	"GRAPH", NULL,			/* 0x56 */
	NULL, NULL,				/* 0x57 */
	NULL, NULL,				/* 0x58 */
	NULL, NULL,				/* 0x59 */
	"Ji", NULL,			/* 0x5A */
	NULL, NULL,				/* 0x5B */
	"BREAK", "(STOP)",		/* 0x5C */
	"PF1",	NULL,			/* 0x5D */
	"PF2",	NULL,			/* 0x5E */
	"PF3",	NULL,			/* 0x5F */
	"PF4",	NULL,			/* 0x60 */
	"PF5",	NULL,			/* 0x61 */
	"PF6",	NULL,			/* 0x62 */
	"PF7",	NULL,			/* 0x63 */
	"PF8",	NULL,			/* 0x64 */
	"PF9",	NULL,			/* 0x65 */
	"PF10",	NULL			/* 0x66 */
};
#endif

/*
 *	CfbNXFM77AV L[R[h
 */
static int FASTCALL KbdPageIndex2FM77AV(int index)
{
	int i;

	for (i=0; i<sizeof(KbdPageFM77AV)/sizeof(char *)/2; i++) {
		/* NULL̃L[̓XLbv */
		if (KbdPageFM77AV[i * 2] == NULL) {
			continue;
		}

		/* NULLłȂ΁A`FbNfNg */
		if (index == 0) {
			return i;
		}
		index--;
	}

	/* G[ */
	return 0;
}

/*
 *	FM77AV L[R[hCfbNX
 */
static int FASTCALL KbdPageFM77AV2Index(int keycode)
{
	int i;
	int index;

	index = 0;
	for (i=0; i<sizeof(KbdPageFM77AV)/sizeof(char *)/2; i++) {
		/* L[R[hɓBI */
		if (i == keycode) {
			break;
		}

		/* NULL̃L[̓XLbv */
		if (KbdPageFM77AV[i * 2] == NULL) {
			continue;
		}

		/* NULLłȂ΁ACNg */
		index++;
	}

	return index;
}

/*
 *	FM77AV L[R[hDirectInput L[R[h
 */
static int FASTCALL KbdPageFM77AV2DirectInput(int fm)
{
	int i;

	/*  */
	for (i=0; i<256; i++) {
		if (propdat.KeyMap[i] == fm) {
			return i;
		}
	}

	/* G[ */
	return 0;
}

/*
 *	L[̓_CAO
 *	_CAO
 */
static void FASTCALL KeyInDlgInit(HWND hDlg)
{
	HWND hWnd;
	RECT prect;
	RECT drect;
	int fm;
	int di;
	char formstr[128];
	char string[128];

	ASSERT(hDlg);

	/* eEChE̒ɐݒ */
	hWnd = GetParent(hDlg);
	GetWindowRect(hWnd, &prect);
	GetWindowRect(hDlg, &drect);
	drect.right -= drect.left;
	drect.bottom -= drect.top;
	drect.left = (prect.right - prect.left) / 2 + prect.left;
	drect.left -= (drect.right / 2);
	drect.top = (prect.bottom - prect.top) / 2 + prect.top;
	drect.top -= (drect.bottom / 2);
	MoveWindow(hDlg, drect.left, drect.top, drect.right, drect.bottom, FALSE);

	/* L[ԍeLXg */
	fm = KbdPageIndex2FM77AV(KbdPageSelectID);
	formstr[0] = '\0';
	LoadString(hAppInstance, IDC_KEYIN_LABEL, formstr, sizeof(formstr));
	_snprintf(string, sizeof(string), formstr, fm);
	hWnd = GetDlgItem(hDlg, IDC_KEYIN_LABEL);
	SetWindowText(hWnd, string);

	/* DirectInputL[eLXg */
	di = KbdPageFM77AV2DirectInput(fm);
	ASSERT((di >= 0) && (di < 256));
	hWnd = GetDlgItem(hDlg, IDC_KEYIN_KEY);
	if (KbdPageDirectInput[di]) {
		SetWindowText(hWnd, KbdPageDirectInput[di]);
	}
	else {
		LoadString(hAppInstance, IDC_KEYIN_KEY, string, sizeof(string));
		SetWindowText(hWnd, string);
	}

	/* O[o[N */
	KbdPageCurrentKey = di;
	GetKbd(KbdPageMap);

	/* ^C}[X^[g */
	SetTimer(hDlg, IDD_KEYINDLG, 50, NULL);
}

/*
 *	L[̓_CAO
 *	^C}[
 */
static void FASTCALL KeyInTimer(HWND hDlg)
{
	BYTE buf[256];
	int i;
	HWND hWnd;
	char string[128];

	ASSERT(hDlg);

	/* L[ */
	LockVM();
	GetKbd(buf);
	UnlockVM();

	/* 񉟂ꂽL[ */
	for (i=0; i<256; i++) {
		if ((KbdPageMap[i] ^ buf[i]) & 0x80) {
			break;
		}
	}

	/* L[}bvXVA`FbN */
	memcpy(KbdPageMap, buf, 256);
	if (i >= 256) {
		return;
	}

	/* L[̔ԍAeLXgZbg */
	KbdPageCurrentKey = i;

	hWnd = GetDlgItem(hDlg, IDC_KEYIN_KEY);
	if (KbdPageDirectInput[i]) {
		SetWindowText(hWnd, KbdPageDirectInput[i]);
	}
	else {
		LoadString(hAppInstance, IDC_KEYIN_KEY, string, sizeof(string));
		SetWindowText(hWnd, string);
	}
}

/*
 *	L[̓_CAO
 *	_CAOvV[W
 */
static BOOL CALLBACK KeyInDlgProc(HWND hDlg, UINT iMsg,
									WPARAM wParam, LPARAM lParam)
{
	UNUSED(lParam);

	switch (iMsg) {
		/* _CAO */
		case WM_INITDIALOG:
			KeyInDlgInit(hDlg);

			/* IMEIt */
			EnableIME(hDlg, FALSE);

			return TRUE;

		/* R}h */
		case WM_COMMAND:
			if (LOWORD(wParam) != IDCANCEL) {
				return TRUE;
			}
			/* ESCL[m邽߂̍Hv */
			if (KbdPageCurrentKey == 0x01) {
				EndDialog(hDlg, IDCANCEL);
				return TRUE;
			}
			KeyInTimer(hDlg);
			if (KbdPageCurrentKey == 0x01) {
				return TRUE;
			}
			EndDialog(hDlg, IDCANCEL);
			return TRUE;

		/* ^C}[ */
		case WM_TIMER:
			KeyInTimer(hDlg);
			return TRUE;

		/* ENbN */
		case WM_RBUTTONDOWN:
			EndDialog(hDlg, IDOK);
			return TRUE;

		/* EChEj */
		case WM_DESTROY:
			KillTimer(hDlg, IDD_KEYINDLG);

			/* IMEI */
			EnableIME(hDlg, TRUE);

			break;
	}

	/* ȊOFALSE */
	return FALSE;
}

/*-[ Nbv{[h\t/L[͎x@\ݒ_CAO ]----------------*/

#ifdef KBDPASTE
/*
 *	Nbv{[h\t/L[͎x@\ݒ_CAO
 *	R}h
 */
static void FASTCALL KbdCopyPasteDlgCmd(HWND hDlg, WORD wID, WORD wNotifyCode,
									 HWND hWnd)
{
	int tmp;
	HWND hSpin;

	ASSERT(hDlg);
	UNUSED(hWnd);

	/* ID */
	switch (wID) {
		/* ʏL[y[XgԊu */
		case IDC_PASTEEDIT:
			if (wNotifyCode == EN_CHANGE) {
				tmp = GetDlgItemInt(hDlg, IDC_PASTEEDIT, 0, FALSE) / 10;
				if (tmp < 0) {
					tmp = 0;
				}
				else if (tmp > 100) {
					tmp = 100;
				}

				hSpin = GetDlgItem(hDlg, IDC_PASTESPIN);
				ASSERT(hSpin);
				UpDown_SetPos(hSpin, tmp);
			}
			break;

		/* Rg[L[y[XgԊu */
		case IDC_PASTECNTLEDIT:
			if (wNotifyCode == EN_CHANGE) {
				tmp = GetDlgItemInt(hDlg, IDC_PASTECNTLEDIT, 0, FALSE) / 10;
				if (tmp < 0) {
					tmp = 0;
				}
				else if (tmp > 100) {
					tmp = 100;
				}

				hSpin = GetDlgItem(hDlg, IDC_PASTECNTLSPIN);
				ASSERT(hSpin);
				UpDown_SetPos(hSpin, tmp);
			}
			break;
	}
}

/*
 *	Nbv{[h\t/L[͎x@\ݒ_CAO
 *	XN[
 */
static void FASTCALL KbdCopyPasteDlgVScroll(HWND hDlg, WORD wPos, HWND hWnd)
{
	HWND hBuddyWnd;
	char string[128];

	ASSERT(hDlg);
	ASSERT(hWnd);

	/* EChEnh`FbN */
	if (hWnd == GetDlgItem(hDlg, IDC_PASTESPIN)) {
		/* ʏL[y[XgԊu */
		/* |WVAofBEChEɒlݒ */
		hBuddyWnd = GetDlgItem(hDlg, IDC_PASTEEDIT);
		ASSERT(hBuddyWnd);
		_snprintf(string, sizeof(string), "%d", wPos * 10);
		SetWindowText(hBuddyWnd, string);
	}
	else if (hWnd == GetDlgItem(hDlg, IDC_PASTECNTLSPIN)) {
		/* Rg[L[y[XgԊu */
		/* |WVAofBEChEɒlݒ */
		hBuddyWnd = GetDlgItem(hDlg, IDC_PASTECNTLEDIT);
		ASSERT(hBuddyWnd);
		_snprintf(string, sizeof(string), "%d", wPos * 10);
		SetWindowText(hBuddyWnd, string);
	}
}

/*
 *	Nbv{[h\t/L[͎x@\ݒ_CAO
 *	_CAO
 */
static BOOL FASTCALL KbdCopyPasteDlgInit(HWND hDlg)
{
	HWND hWnd;
	RECT prect;
	RECT drect;

	ASSERT(hDlg);

	/* eEChE̒ɐݒ */
	hWnd = GetParent(hDlg);
	GetWindowRect(hWnd, &prect);
	GetWindowRect(hDlg, &drect);
	drect.right -= drect.left;
	drect.bottom -= drect.top;
	drect.left = (prect.right - prect.left) / 2 + prect.left;
	drect.left -= (drect.right / 2);
	drect.top = (prect.bottom - prect.top) / 2 + prect.top;
	drect.top -= (drect.bottom / 2);
	MoveWindow(hDlg, drect.left, drect.top, drect.right, drect.bottom, FALSE);

	/* TEhobt@ */
	hWnd = GetDlgItem(hDlg, IDC_PASTESPIN);
	ASSERT(hWnd);
	UpDown_SetRange(hWnd, 100, 0);
	UpDown_SetPos(hWnd, propdat.uPasteWait / 10);
	KbdCopyPasteDlgVScroll(hDlg, LOWORD(UpDown_GetPos(hWnd)), hWnd);

	/* BEEPg */
	hWnd = GetDlgItem(hDlg, IDC_PASTECNTLSPIN);
	ASSERT(hWnd);
	UpDown_SetRange(hWnd, 100, 0);
	UpDown_SetPos(hWnd, propdat.uPasteWaitCntl / 10);
	KbdCopyPasteDlgVScroll(hDlg, LOWORD(UpDown_GetPos(hWnd)), hWnd);

	return TRUE;
}

/*
 *	Nbv{[h\t/L[͎x@\ݒ_CAO
 *	_CAOOK
 */
static void FASTCALL KbdCopyPasteDlgOK(HWND hDlg)
{
	HWND hWnd;

	ASSERT(hDlg);

	/* GfBbgeLXg */
	hWnd = GetDlgItem(hDlg, IDC_PASTESPIN);
	ASSERT(hWnd);
	propdat.uPasteWait = LOWORD(UpDown_GetPos(hWnd)) * 10;

	/* GfBbgeLXg */
	hWnd = GetDlgItem(hDlg, IDC_PASTECNTLSPIN);
	ASSERT(hWnd);
	propdat.uPasteWaitCntl = LOWORD(UpDown_GetPos(hWnd)) * 10;
}

/*
 *	Nbv{[h\t/L[͎x@\ݒ_CAO
 *	_CAOvV[W
 */
static BOOL CALLBACK KbdCopyPasteDlgProc(HWND hDlg, UINT iMsg,
									WPARAM wParam, LPARAM lParam)
{
	switch (iMsg) {
		/* _CAO */
		case WM_INITDIALOG:
			/* IMEIt */
			EnableIME(hDlg, FALSE);

			return KbdCopyPasteDlgInit(hDlg);

		/* R}h */
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				/* OKELZ */
				case IDOK:
				case IDCANCEL:
					/* IMEI */
					EnableIME(hDlg, TRUE);

					if (LOWORD(wParam) == IDOK) {
						KbdCopyPasteDlgOK(hDlg);
					}
					EndDialog(hDlg, LOWORD(wParam));
					InvalidateRect(hDrawWnd, NULL, FALSE);
					SetMenuExitTimer();
					return TRUE;

				/* ̑(y[XgԊu) */
				default:
					KbdCopyPasteDlgCmd(hDlg, LOWORD(wParam), HIWORD(wParam),
						(HWND)lParam);
					return TRUE;
		}

		/* XN[ */
		case WM_VSCROLL:
			KbdCopyPasteDlgVScroll(hDlg, HIWORD(wParam), (HWND)lParam);
			return TRUE;
	}

	/* ȊÓAFALSE */
	return FALSE;
}
#endif

/*-[ L[{[hy[W ]-----------------------------------------------------*/

/*
 *	L[{[hy[W
 *	_CAO(wb_[ACe)
 */
static void FASTCALL KbdPageInitColumn(HWND hWnd)
{
	int i;
	char string[128];
	TEXTMETRIC tm;
	HDC hDC;
	LV_COLUMN lvc;
	static const UINT uHeaderTable[] = {
		IDS_KP_KEYNO,
		IDS_KP_KEYFM,
		IDS_KP_KEYKANA,
		IDS_KP_KEYDI
	};

	ASSERT(hWnd);

	/* eLXggbN擾 */
	hDC = GetDC(hWnd);
	GetTextMetrics(hDC, &tm);
	ReleaseDC(hWnd, hDC);

	/* }[v */
	for (i=0; i<(sizeof(uHeaderTable)/sizeof(UINT)); i++) {
		/* eLXg[h */
		LoadString(hAppInstance, uHeaderTable[i], string, sizeof(string));

		/* J\̂쐬 */
		lvc.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_WIDTH | LVCF_TEXT;
		lvc.iSubItem = i;
		lvc.fmt = LVCFMT_LEFT;
		lvc.cx = (strlen(string) + 1) * tm.tmAveCharWidth;
		lvc.pszText = string;
		lvc.cchTextMax = strlen(string);

		/* J} */
		ListView_InsertColumn(hWnd, i, &lvc);
	}
}

/*
 *	L[{[hy[W
 *	TuACeꊇݒ
 */
static void FASTCALL KbdPageSubItem(HWND hDlg)
{
	HWND hWnd;
	int i;
	int j;
	int index;

	/* XgRg[擾 */
	hWnd = GetDlgItem(hDlg, IDC_KP_LIST);
	ASSERT(hWnd);

	/* ACe} */
	for (index=0; ; index++) {
		/* FM77AVL[ԍ𓾂 */
		i = KbdPageIndex2FM77AV(index);
		if (i == 0) {
			break;
		}

		/* YDirectXL[ԍ𓾂 */
		j = KbdPageFM77AV2DirectInput(i);

		/* Zbg */
		if (KbdPageDirectInput[j]) {
			ListView_SetItemText(hWnd, index, 3, KbdPageDirectInput[j]);
		}
		else {
			ListView_SetItemText(hWnd, index, 3, "");
		}
	}
}

/*
 *	L[{[hy[W
 *	_CAO
 */
static void FASTCALL KbdPageInit(HWND hDlg)
{
	HWND hWnd;
	LV_ITEM lvi;
	int index;
	int i;
	char string[128];

	/* V[g */
	SheetInit(hDlg);

	/* XgRg[擾 */
	hWnd = GetDlgItem(hDlg, IDC_KP_LIST);
	ASSERT(hWnd);

	/* J} */
	KbdPageInitColumn(hWnd);

	/* ACe} */
	for (index=0; ; index++) {
		/* FM77AVL[ԍ𓾂 */
		i = KbdPageIndex2FM77AV(index);
		if (i == 0) {
			break;
		}

		/* ACe} */
		_snprintf(string, sizeof(string), "%02X", i);
		lvi.mask = LVIF_TEXT;
		lvi.pszText = string;
		lvi.cchTextMax = strlen(string);
		lvi.iItem = index;
		lvi.iSubItem = 0;
		ListView_InsertItem(hWnd, &lvi);

		/* TuACe~QZbg */
		if (KbdPageFM77AV[i * 2 + 0]) {
			ListView_SetItemText(hWnd, index, 1, KbdPageFM77AV[i * 2 + 0]);
		}
		if (KbdPageFM77AV[i * 2 + 1]) {
			ListView_SetItemText(hWnd, index, 2, KbdPageFM77AV[i * 2 + 1]);
		}
	}

	/* L[}bvݒ肪LȂƂ̓XgRg[𖳌 */
	if (bAutoDetectKeyMap) {
		hWnd = GetDlgItem(hDlg, IDC_KP_LIST);
		ASSERT(hWnd);
		EnableWindow(hWnd, FALSE);
		hWnd = GetDlgItem(hDlg, IDC_KP_101B);
		ASSERT(hWnd);
		EnableWindow(hWnd, FALSE);
		hWnd = GetDlgItem(hDlg, IDC_KP_106B);
		ASSERT(hWnd);
		EnableWindow(hWnd, FALSE);
		hWnd = GetDlgItem(hDlg, IDC_KP_98B);
		ASSERT(hWnd);
		EnableWindow(hWnd, FALSE);
	}

	/* TuACe */
	KbdPageSubItem(hDlg);

	/* eL[G~[V */
	if (propdat.bTenCursor) {
		CheckDlgButton(hDlg, IDC_KP_USEARROWFOR10, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_KP_USEARROWFOR10, BST_UNCHECKED);
	}

	/* eL[G~[V8[h */
	if (propdat.bArrow8Dir) {
		CheckDlgButton(hDlg, IDC_KP_ARROW8DIR, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_KP_ARROW8DIR, BST_UNCHECKED);
	}
	hWnd = GetDlgItem(hDlg, IDC_KP_ARROW8DIR);
	EnableWindow(hWnd, propdat.bTenCursor);

	/* ^A^CL[XL */
	if (propdat.bKbdReal) {
		CheckDlgButton(hDlg, IDC_KP_KBDREAL, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_KP_KBDREAL, BST_UNCHECKED);
	}
}

/*
 *	L[{[hy[W
 *	R}h
 */
static void FASTCALL KbdPageCmd(HWND hDlg, WORD wID, WORD wNotifyCode, HWND hWnd)
{
	ASSERT(hDlg);
	UNUSED(wNotifyCode);
	UNUSED(hWnd);

	switch (wID) {
		/* 106L[{[h */
		case IDC_KP_106B:
			GetDefMapKbd(propdat.KeyMap, 1);
			KbdPageSubItem(hDlg);
			break;

		/* PC-98L[{[h */
		case IDC_KP_98B:
			GetDefMapKbd(propdat.KeyMap, 2);
			KbdPageSubItem(hDlg);
			break;

		/* 101L[{[h */
		case IDC_KP_101B:
			GetDefMapKbd(propdat.KeyMap, 3);
			KbdPageSubItem(hDlg);
			break;

#ifdef KBDPASTE
		/* Nbv{[h\t/L[͎x@\ݒ */
		case IDC_KP_COPYPASTE:
			DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_COPYPASTEDLG), hDlg,
				(DLGPROC)KbdCopyPasteDlgProc);
			break;
#endif

		/* eL[G~[V */
		case IDC_KP_USEARROWFOR10:
			hWnd = GetDlgItem(hDlg, IDC_KP_ARROW8DIR);
			if (IsDlgButtonChecked(hDlg, wID) == BST_CHECKED) {
				EnableWindow(hWnd, TRUE);
			}
			else {
				EnableWindow(hWnd, FALSE);
			}
			break;
	}
}

/*
 *	L[{[hy[W
 *	_uNbN
 */
static void FASTCALL KbdPageDblClk(HWND hDlg)
{
	HWND hWnd;
	int count;
	int i;
	int j;

	ASSERT(hDlg);

	/* XgRg[擾 */
	hWnd = GetDlgItem(hDlg, IDC_KP_LIST);
	ASSERT(hWnd);

	/* IĂACe΁A^[ */
	if (ListView_GetSelectedCount(hWnd) == 0) {
		return;
	}

	/* o^ĂACě擾 */
	count = ListView_GetItemCount(hWnd);

	/* ZNgĂCfbNX𓾂 */
	for (i=0; i<count; i++) {
		if (ListView_GetItemState(hWnd, i, LVIS_SELECTED)) {
			break;
		}
	}

	/* O[o֋L */
	ASSERT(i < count);
	KbdPageSelectID = i;

	/* [__CAOs */
	if (DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_KEYINDLG),
						hDlg, (DLGPROC)KeyInDlgProc) == IDOK) {
		/* }bvC */
		j = KbdPageIndex2FM77AV(i);
		for (i=0; i<256; i++) {
			if (propdat.KeyMap[i] == j) {
				propdat.KeyMap[i] = 0;
			}
		}
		propdat.KeyMap[KbdPageCurrentKey] = (BYTE)j;

		/* ĕ` */
		KbdPageSubItem(hDlg);
	}
}

/*
 *	L[{[hy[W
 *	Kp
 */
static void FASTCALL KbdPageApply(HWND hDlg)
{
	/* Xe[gύX */
	uPropertyState = 2;

	/* eL[G~[V */
	if (IsDlgButtonChecked(hDlg, IDC_KP_USEARROWFOR10) == BST_CHECKED) {
		propdat.bTenCursor = TRUE;
	}
	else {
		propdat.bTenCursor = FALSE;
	}

	/* eL[G~[V 8[h */
	if (IsDlgButtonChecked(hDlg, IDC_KP_ARROW8DIR) == BST_CHECKED) {
		propdat.bArrow8Dir = TRUE;
	}
	else {
		propdat.bArrow8Dir = FALSE;
	}

	/* ^A^CL[XL */
	if (IsDlgButtonChecked(hDlg, IDC_KP_KBDREAL) == BST_CHECKED) {
		propdat.bKbdReal = TRUE;
	}
	else {
		propdat.bKbdReal = FALSE;
	}
}

/*
 *	L[{[hy[W
 *	_CAOvV[W
 */
static BOOL CALLBACK KbdPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;
	LV_KEYDOWN *plkd;

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			KbdPageInit(hDlg);
			return TRUE;

		/* R}h */
		case WM_COMMAND:
			KbdPageCmd(hDlg, LOWORD(wParam), HIWORD(wParam), (HWND)lParam);
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			/* y[WI */
			if (pnmh->code == PSN_APPLY) {
				KbdPageApply(hDlg);
				return TRUE;
			}
			/* Xgr[ _uNbN */
			if ((pnmh->idFrom == IDC_KP_LIST) && (pnmh->code == NM_DBLCLK)) {
				KbdPageDblClk(hDlg);
				return TRUE;
			}
			/* Xgr[ L[ */
			if ((pnmh->idFrom == IDC_KP_LIST) && (pnmh->code == LVN_KEYDOWN)) {
				plkd = (LV_KEYDOWN*)pnmh;
				/* SPACE͂ꂽL[I */
				if (plkd->wVKey == VK_SPACE) {
					KbdPageDblClk(hDlg);
					return TRUE;
				}
			}
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_KP_HELP);
			}
			break;
	}

	return FALSE;
}

/*-[ WCXeBbNy[W ]-----------------------------------------------*/

/*
 *	WCXeBbNy[W
 *	R{{bNXe[u
 */
static const UINT JoyPageComboTable[] = {
	IDC_JP_UPC,
	IDC_JP_DOWNC,
	IDC_JP_LEFTC,
	IDC_JP_RIGHTC,
	IDC_JP_CENTERC,
	IDC_JP_AC,
	IDC_JP_BC
};

/*
 *	WCXeBbNy[W
 *	R[he[u
 */
static const UINT JoyPageCodeTable[] = {
	IDS_JP_TYPE0,
	IDC_JP_UP,
	IDC_JP_DOWN,
	IDC_JP_LEFT,
	IDC_JP_RIGHT,
	IDC_JP_A,
	IDC_JP_B
};

/*
 *	WCXeBbNy[W
 *	R{{bNXZNg
 */
static void FASTCALL JoyPageCombo(HWND hDlg, WORD wID)
{
	int i;
	int j;
	HWND hWnd;
	char string[128];

	ASSERT(hDlg);

	/* ID`FbN */
	if (wID != IDC_JP_TYPEC) {
		return;
	}

	/* "gpȂ"bZ[W[h */
	string[0] = '\0';
	LoadString(hAppInstance, IDS_JP_TYPE0, string, sizeof(string));

	/* R{bNXNA */
	for (i=0; i<sizeof(JoyPageComboTable)/sizeof(UINT); i++) {
		hWnd = GetDlgItem(hDlg, JoyPageComboTable[i]);
		ASSERT(hWnd);
		(void)ComboBox_ResetContent(hWnd);
	}

	/* ^Cv擾 */
	hWnd = GetDlgItem(hDlg, IDC_JP_TYPEC);
	ASSERT(hWnd);
	j = ComboBox_GetCurSel(hWnd);

	/* L[{[h̏ꍇ */
	if (j == 3) {
		for (i=0; i<sizeof(JoyPageComboTable)/sizeof(UINT); i++) {
			/* nh擾 */
			hWnd = GetDlgItem(hDlg, JoyPageComboTable[i]);
			ASSERT(hWnd);

			/* L[R[h} */
			(void)ComboBox_AddString(hWnd, string);
			for (j=0; j<sizeof(KbdPageFM77AV)/sizeof(char*); j+=2) {
				if (KbdPageFM77AV[j]) {
					(void)ComboBox_AddString(hWnd, KbdPageFM77AV[j]);
				}
			}
			/* L[R[hɃJ[\킹 */
			if (propdat.nJoyCode[JoyPageIdx][i] == 0) {
				(void)ComboBox_SetCurSel(hWnd, 0);
				continue;
			}
			if (propdat.nJoyCode[JoyPageIdx][i] > 0x66) {
				(void)ComboBox_SetCurSel(hWnd, 0);
				continue;
			}
			j = KbdPageFM77AV2Index(propdat.nJoyCode[JoyPageIdx][i]);
			(void)ComboBox_SetCurSel(hWnd, j + 1);
		}
		return;
	}

	/* WCXeBbN̏ꍇ */
	for (i=0; i<sizeof(JoyPageComboTable)/sizeof(UINT); i++) {
		/* nh擾 */
		hWnd = GetDlgItem(hDlg, JoyPageComboTable[i]);
		ASSERT(hWnd);

		/* } */
		for (j=0; j<sizeof(JoyPageCodeTable)/sizeof(UINT); j++) {
			string[0] = '\0';
			LoadString(hAppInstance, JoyPageCodeTable[j], string, sizeof(string));
			(void)ComboBox_AddString(hWnd, string);
		}

		/* J[\ݒ */
		if (propdat.nJoyCode[JoyPageIdx][i] < 0x70) {
			(void)ComboBox_SetCurSel(hWnd, 0);
			continue;
		}
		if (propdat.nJoyCode[JoyPageIdx][i] < 0x74) {
			(void)ComboBox_SetCurSel(hWnd, propdat.nJoyCode[JoyPageIdx][i] - 0x70 + 1);
			continue;
		}
		(void)ComboBox_SetCurSel(hWnd, propdat.nJoyCode[JoyPageIdx][i] - 0x74 + 5);
	}
}

/*
 *	WCXeBbNy[W
 *	f[^Zbg
 */
static void FASTCALL JoyPageSet(HWND hDlg)
{
	HWND hWnd;

	ASSERT(hDlg);
	ASSERT((JoyPageIdx == 0) || (JoyPageIdx == 1));

	/* A˃R{{bNX */
	hWnd = GetDlgItem(hDlg, IDC_JP_RAPIDAC);
	ASSERT(hWnd);
	(void)ComboBox_SetCurSel(hWnd, propdat.nJoyRapid[JoyPageIdx][0]);
	hWnd = GetDlgItem(hDlg, IDC_JP_RAPIDBC);
	ASSERT(hWnd);
	(void)ComboBox_SetCurSel(hWnd, propdat.nJoyRapid[JoyPageIdx][1]);

	/* ^CvR{{bNX */
	hWnd = GetDlgItem(hDlg, IDC_JP_TYPEC);
	ASSERT(hWnd);
	(void)ComboBox_SetCurSel(hWnd, propdat.nJoyType[JoyPageIdx]);

	/* R[h */
	JoyPageCombo(hDlg, IDC_JP_TYPEC);
}

/*
 *	WCXeBbNy[W
 *	f[^擾
 */
static void FASTCALL JoyPageGet(HWND hDlg)
{
	HWND hWnd;
	int i;
	int j;

	ASSERT(hDlg);
	ASSERT((JoyPageIdx == 0) || (JoyPageIdx == 1));

	/* A˃R{{bNX */
	hWnd = GetDlgItem(hDlg, IDC_JP_RAPIDAC);
	ASSERT(hWnd);
	propdat.nJoyRapid[JoyPageIdx][0] = ComboBox_GetCurSel(hWnd);
	hWnd = GetDlgItem(hDlg, IDC_JP_RAPIDBC);
	ASSERT(hWnd);
	propdat.nJoyRapid[JoyPageIdx][1] = ComboBox_GetCurSel(hWnd);

	/* ^CvR{{bNX */
	hWnd = GetDlgItem(hDlg, IDC_JP_TYPEC);
	ASSERT(hWnd);
	propdat.nJoyType[JoyPageIdx] = ComboBox_GetCurSel(hWnd);

	/* R[h */
	if (propdat.nJoyType[JoyPageIdx] == 3) {
		/* L[{[h */
		for (i=0; i<sizeof(JoyPageComboTable)/sizeof(UINT); i++) {
			/* nh擾 */
			hWnd = GetDlgItem(hDlg, JoyPageComboTable[i]);
			ASSERT(hWnd);

			/* R[hϊAZbg */
			j = ComboBox_GetCurSel(hWnd);
			if (j != 0) {
				j = KbdPageIndex2FM77AV(j - 1);
			}
			propdat.nJoyCode[JoyPageIdx][i] = j;
		}
		return;
	}

	/* WCXeBbN */
	for (i=0; i<sizeof(JoyPageComboTable)/sizeof(UINT); i++) {
		/* nh擾 */
		hWnd = GetDlgItem(hDlg, JoyPageComboTable[i]);
		ASSERT(hWnd);

		/* R[hϊAZbg */
		j = ComboBox_GetCurSel(hWnd);
		if (j == 0) {
			propdat.nJoyCode[JoyPageIdx][i] = 0;
			continue;
		}
		if (j < 5) {
			propdat.nJoyCode[JoyPageIdx][i] = (j - 1) + 0x70;
			continue;
		}
		propdat.nJoyCode[JoyPageIdx][i] = (j - 5) + 0x74;
	}
}

/*
 *	WCXeBbNy[W
 *	{^ꂽ
 */
static void FASTCALL JoyPageButton(HWND hDlg, WORD wID)
{
	ASSERT(hDlg);

	switch (wID) {
		/* |[g1 I */
		case IDC_JP_PORT1:
			JoyPageGet(hDlg);
			JoyPageIdx = 0;
			JoyPageSet(hDlg);
			break;

		/* |[g2 I */
		case IDC_JP_PORT2:
			JoyPageGet(hDlg);
			JoyPageIdx = 1;
			JoyPageSet(hDlg);
			break;

		/* ȊO */
		default:
			ASSERT(FALSE);
			break;
	}
}

/*
 *	WCXeBbNy[W
 *	_CAO
 */
static void FASTCALL JoyPageInit(HWND hDlg)
{
	HWND hWnd[2];
	int i;
	char string[128];
#ifdef LPRINT
	int nJoyStick;
#endif

	/* V[g */
	ASSERT(hDlg);
	SheetInit(hDlg);

	/* ^CvR{{bNX */
	hWnd[0] = GetDlgItem(hDlg, IDC_JP_TYPEC);
	ASSERT(hWnd[0]);
	(void)ComboBox_ResetContent(hWnd[0]);
#ifdef LPRINT
	/* v^gp */
	if (lp_use != 0) {
		nJoyStick = 4;	/* "v^|[gڑJOY I/F"  */
	}
	else {
		nJoyStick = 8;	/* "v^|[gڑJOY I/F" ܂ */
	}
	for (i=0; i<nJoyStick; i++) {
#else
	for (i=0; i<5; i++) {
#endif
		string[0] = '\0';
		LoadString(hAppInstance, IDS_JP_TYPE0 + i, string, sizeof(string));
		(void)ComboBox_AddString(hWnd[0], string);
	}
	(void)ComboBox_SetCurSel(hWnd[0], 0);

	/* A˃R{{bNX */
	hWnd[0] = GetDlgItem(hDlg, IDC_JP_RAPIDAC);
	ASSERT(hWnd[0]);
	(void)ComboBox_ResetContent(hWnd[0]);
	hWnd[1] = GetDlgItem(hDlg, IDC_JP_RAPIDBC);
	ASSERT(hWnd[1]);
	(void)ComboBox_ResetContent(hWnd[1]);
	for (i=0; i<10; i++) {
		string[0] = '\0';
		LoadString(hAppInstance, IDS_JP_RAPID0 + i, string, sizeof(string));
		(void)ComboBox_AddString(hWnd[0], string);
		(void)ComboBox_AddString(hWnd[1], string);
	}
	(void)ComboBox_SetCurSel(hWnd[0], 0);
	(void)ComboBox_SetCurSel(hWnd[1], 0);

	/* |[gIO[v{^ */
	CheckDlgButton(hDlg, IDC_JP_PORT1, BST_CHECKED);
	JoyPageIdx = 0;
	JoyPageSet(hDlg);
}

/*
 *	WCXeBbNy[W
 *	Kp
 */
static void FASTCALL JoyPageApply(HWND hDlg)
{
	ASSERT(hDlg);

	/* Xe[gύX */
	uPropertyState = 2;

	/* f[^擾 */
	JoyPageGet(hDlg);
}

/*
 *	WCXeBbNy[W
 *	_CAOvV[W
 */
static BOOL CALLBACK JoyPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			JoyPageInit(hDlg);
			return TRUE;

		/* R}h */
		case WM_COMMAND:
			switch (HIWORD(wParam)) {
				/* {^NbN */
				case BN_CLICKED:
					JoyPageButton(hDlg, LOWORD(wParam));
					break;
				/* R{I */
				case CBN_SELCHANGE:
					JoyPageCombo(hDlg, LOWORD(wParam));
					break;
			}
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				JoyPageApply(hDlg);
				return TRUE;
			}
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_JP_HELP);
			}
			break;
	}

	return FALSE;
}
/*-[ XN[y[W ]-----------------------------------------------------*/

/*
 *	XN[y[W
 *	_CAO
 */
static void FASTCALL ScrPageInit(HWND hDlg)
{
	HWND hWnd;
	char string[128];
	int i;

	/* V[g */
	ASSERT(hDlg);
	SheetInit(hDlg);

	/* SʗD惂[h */
	hWnd = GetDlgItem(hDlg, IDC_SCP_MODEC);
	ASSERT(hWnd);
	string[0] = '\0';
	(void)ComboBox_ResetContent(hWnd);
	for (i=0; i<5; i++) {
		LoadString(hAppInstance, IDS_SCP_400LINE + i, string, sizeof(string));
		(void)ComboBox_AddString(hWnd, string);
	}
	(void)ComboBox_SetCurSel(hWnd, propdat.nDDResolutionMode);

	/* EBhE[htXL(24k) */
	if (propdat.bFullScan) {
		CheckDlgButton(hDlg, IDC_SCP_24K, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SCP_24K, BST_UNCHECKED);
	}

	/* tXN[tXL(24k) */
	if (propdat.bFullScanFS) {
		CheckDlgButton(hDlg, IDC_SCP_24KFS, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SCP_24KFS, BST_UNCHECKED);
	}

	/* EBhE[h2{\ */
	if (propdat.bDoubleSize) {
		CheckDlgButton(hDlg, IDC_SCP_DOUBLESIZE, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SCP_DOUBLESIZE, BST_UNCHECKED);
	}

	/* ㉺Xe[^X */
	if (propdat.bDD480Status) {
		CheckDlgButton(hDlg, IDC_SCP_CAPTIONB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SCP_CAPTIONB, BST_UNCHECKED);
	}

	/* ʕ`ʒm^C~O */
	if (propdat.bRasterRender) {
		CheckDlgButton(hDlg, IDC_SCP_RASTERRENDER, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SCP_RASTERRENDER, BST_UNCHECKED);
	}

	/* O[j^/TTLj^[h(V1/V2ʏ) */
#if XM7_VER <= 2
	if (propdat.nMonitorType != MONITOR_COLOR) {
		CheckDlgButton(hDlg, IDC_SCP_MONITORTYPE, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SCP_MONITORTYPE, BST_UNCHECKED);
	}
#endif

	/* TrueColorD */
	if (propdat.bDDtruecolor || bWin8flag) {
		CheckDlgButton(hDlg, IDC_SCP_TRUECOLOR, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SCP_TRUECOLOR, BST_UNCHECKED);
	}
	hWnd = GetDlgItem(hDlg, IDC_SCP_TRUECOLOR);
	EnableWindow(hWnd, !bWin8flag);

	/* ^400C */
	if (propdat.bPseudo400Line) {
		CheckDlgButton(hDlg, IDC_SCP_PSEUDO400LINE, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_SCP_PSEUDO400LINE, BST_UNCHECKED);
	}
}

/*
 *	XN[y[W
 *	Kp
 */
static void FASTCALL ScrPageApply(HWND hDlg)
{
	HWND hWnd;

	ASSERT(hDlg);

	/* Xe[gύX */
	uPropertyState = 2;

	/* SʗD惂[h */
	hWnd = GetDlgItem(hDlg, IDC_SCP_MODEC);
	ASSERT(hWnd);
	propdat.nDDResolutionMode = (BYTE)ComboBox_GetCurSel(hWnd);
	if (propdat.nDDResolutionMode > 4) {
		propdat.nDDResolutionMode = DDRES_480LINE;
	}

	/* EBhE[htXL(24k) */
	if (IsDlgButtonChecked(hDlg, IDC_SCP_24K) == BST_CHECKED) {
		propdat.bFullScan = TRUE;
	}
	else {
		propdat.bFullScan = FALSE;
	}

	/* tXN[tXL(24k) */
	if (IsDlgButtonChecked(hDlg, IDC_SCP_24KFS) == BST_CHECKED) {
		propdat.bFullScanFS = TRUE;
	}
	else {
		propdat.bFullScanFS = FALSE;
	}

	/* EBhE[h2{\ */
	if (IsDlgButtonChecked(hDlg, IDC_SCP_DOUBLESIZE) == BST_CHECKED) {
		propdat.bDoubleSize = TRUE;
	}
	else {
		propdat.bDoubleSize = FALSE;
	}

	/* ㉺Xe[^X */
	if (IsDlgButtonChecked(hDlg, IDC_SCP_CAPTIONB) == BST_CHECKED) {
		propdat.bDD480Status = TRUE;
	}
	else {
		propdat.bDD480Status = FALSE;
	}

	/* X^_O */
	if (IsDlgButtonChecked(hDlg, IDC_SCP_RASTERRENDER) == BST_CHECKED) {
		propdat.bRasterRender = TRUE;
	}
	else {
		propdat.bRasterRender = FALSE;
	}

	/* O[j^/TTLj^[h(V1/V2ʏ) */
#if XM7_VER <= 2
	if (IsDlgButtonChecked(hDlg, IDC_SCP_MONITORTYPE) == BST_CHECKED) {
#if XM7_VER == 2
		propdat.nMonitorType = MONITOR_FORCETTLCOLOR;
#else
		if (bIsAmberMonitor) {
			propdat.nMonitorType = MONITOR_AMBERYELLOW;
		}
		else {
			propdat.nMonitorType = MONITOR_GREEN;
		}
#endif
	}
	else {
		propdat.nMonitorType = MONITOR_COLOR;
	}
#endif

	/* TrueColorD */
	if (IsDlgButtonChecked(hDlg, IDC_SCP_TRUECOLOR) == BST_CHECKED) {
		propdat.bDDtruecolor = TRUE;
	}
	else {
		propdat.bDDtruecolor = FALSE;
	}

	/* ^SOOC[h */
	if (IsDlgButtonChecked(hDlg, IDC_SCP_PSEUDO400LINE) == BST_CHECKED) {
		propdat.bPseudo400Line = TRUE;
	}
	else {
		propdat.bPseudo400Line = FALSE;
	}
}

/*
 *	XN[y[W
 *	_CAOvV[W
 */
static BOOL CALLBACK ScrPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	UNUSED(wParam);

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			ScrPageInit(hDlg);
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				ScrPageApply(hDlg);
				return TRUE;
			}
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_SCP_HELP);
			}
			break;
	}

	return FALSE;
}

/*-[ |[gy[W ]---------------------------------------------------------*/

#if defined(MIDI) || defined(RSC)

#ifdef MIDI
/*
 *	|[gy[W
 *	R}h
 */
static void FASTCALL PortPageCmd(HWND hDlg, WORD wID, WORD wNotifyCode, HWND hWnd)
{
	HWND hSpin;
	BOOL flag;
	int tmp;

	ASSERT(hDlg);

	/* ID */
	switch (wID) {
		/* MIDIx */
		case IDC_POP_MIDIDLYEDIT:
			if (wNotifyCode == EN_CHANGE) {
				tmp = GetDlgItemInt(hDlg, IDC_POP_MIDIDLYEDIT, 0, FALSE) / 10;
				if (tmp < 0) {
					tmp = 0;
				}
				else if (tmp > 100) {
					tmp = 100;
				}

				hSpin = GetDlgItem(hDlg, IDC_POP_MIDIDLYSPIN);
				ASSERT(hSpin);
				UpDown_SetPos(hSpin, tmp);
			}
			break;

		/* MIDIxTEhobt@ƈv */
		case IDC_POP_MIDIDLYSB:
			if (IsDlgButtonChecked(hDlg, IDC_POP_MIDIDLYSB) == BST_CHECKED) {
				flag = FALSE;
			}
			else {
				flag = TRUE;
			}
			hWnd = GetDlgItem(hDlg, IDC_POP_MIDIDLYSPIN);
			EnableWindow(hWnd, flag);
			hWnd = GetDlgItem(hDlg, IDC_POP_MIDIDLYEDIT);
			EnableWindow(hWnd, flag);
			break;
	}
}

/*
 *	|[gy[W
 *	XN[
 */
static void FASTCALL PortPageVScroll(HWND hDlg, WORD wPos, HWND hWnd)
{
	HWND hBuddyWnd;
	char string[128];

	ASSERT(hDlg);
	ASSERT(hWnd);

	/* EChEnh`FbN */
	if (hWnd == GetDlgItem(hDlg, IDC_POP_MIDIDLYSPIN)) {
		/* MIDIx */
		/* |WVAofBEChEɒlݒ */
		hBuddyWnd = GetDlgItem(hDlg, IDC_POP_MIDIDLYEDIT);
		ASSERT(hBuddyWnd);
		_snprintf(string, sizeof(string), "%d", wPos * 10);
		SetWindowText(hBuddyWnd, string);
	}
}
#endif

/*
 *	|[gy[W
 *	_CAO
 */
static void FASTCALL PortPageInit(HWND hDlg)
{
#ifdef MIDI
	MIDIOUTCAPS moc;
#endif
	HWND hWnd;
	char string[128];
	int i, numsel;

	/* V[g */
	ASSERT(hDlg);
	SheetInit(hDlg);

#ifdef MIDI
	/* MIDI|[gI */
	numsel = 0;
	hWnd = GetDlgItem(hDlg, IDC_POP_MIDIDEVC);
	ASSERT(hWnd);
	string[0] = '\0';
	(void)ComboBox_ResetContent(hWnd);
	LoadString(hAppInstance, IDS_POP_NONE, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	for (i=0; i<(int)midiOutGetNumDevs(); i++) {
		midiOutGetDevCaps(i, &moc, sizeof(moc));
		(void)ComboBox_AddString(hWnd, moc.szPname);
		if (!strcmp(moc.szPname, propdat.szMidiDevice)) {
			numsel = i + 1;
		}
	}
	(void)ComboBox_SetCurSel(hWnd, numsel);

	/* MIDIx */
	hWnd = GetDlgItem(hDlg, IDC_POP_MIDIDLYSPIN);
	ASSERT(hWnd);
	UpDown_SetRange(hWnd, 100, 0);
	UpDown_SetPos(hWnd, propdat.nMidiDelay / 10);
	PortPageVScroll(hDlg, LOWORD(UpDown_GetPos(hWnd)), hWnd);
	EnableWindow(hWnd, !propdat.bMidiDelayMode);
	hWnd = GetDlgItem(hDlg, IDC_POP_MIDIDLYEDIT);
	EnableWindow(hWnd, !propdat.bMidiDelayMode);

	/* MIDIxTEhobt@ƈv */
	if (propdat.bMidiDelayMode) {
		CheckDlgButton(hDlg, IDC_POP_MIDIDLYSB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_POP_MIDIDLYSB, BST_UNCHECKED);
	}
#endif

#ifdef RSC
	/* RS-232Cgp */
	if (propdat.bCommPortEnable) {
		CheckDlgButton(hDlg, IDC_POP_COMENABLE, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_POP_COMENABLE, BST_UNCHECKED);
	}

	/* RS-232C{[[gI */
	hWnd = GetDlgItem(hDlg, IDC_POP_COMBPSC);
	ASSERT(hWnd);
	string[0] = '\0';
	(void)ComboBox_ResetContent(hWnd);
	for (i=0; i<5; i++) {
		LoadString(hAppInstance, IDS_POP_COM300 + i, string, sizeof(string));
		(void)ComboBox_AddString(hWnd, string);
	}
	(void)ComboBox_SetCurSel(hWnd, propdat.uCommPortBps);

	/* RS-232C|[gI */
	hWnd = GetDlgItem(hDlg, IDC_POP_COMPORTC);
	ASSERT(hWnd);
	string[0] = '\0';
	(void)ComboBox_ResetContent(hWnd);
	for (i=1; i<=16; i++) {
		_snprintf(string, sizeof(string), "COM%d", i);
		(void)ComboBox_AddString(hWnd, string);
	}
	(void)ComboBox_SetCurSel(hWnd, propdat.nCommPortNo - 1);
#endif
}

/*
 *	|[gy[W
 *	Kp
 */
static void FASTCALL PortPageApply(HWND hDlg)
{
	MIDIOUTCAPS moc;
	HWND hWnd;
	UINT uPos;
	int i;

	ASSERT(hDlg);

	/* Xe[gύX */
	uPropertyState = 2;

#ifdef MIDI
	/* MIDI|[g */
	hWnd = GetDlgItem(hDlg, IDC_POP_MIDIDEVC);
	i = ComboBox_GetCurSel(hWnd);
	if (i == 0) {
		strncpy(propdat.szMidiDevice, "", sizeof(propdat.szMidiDevice));
	}
	else {
		midiOutGetDevCaps(i - 1, &moc, sizeof(moc));
		strncpy(propdat.szMidiDevice, moc.szPname, 
				sizeof(propdat.szMidiDevice));
	}

	/* MIDIx */
	hWnd = GetDlgItem(hDlg, IDC_POP_MIDIDLYSPIN);
	ASSERT(hWnd);
	uPos = LOWORD(UpDown_GetPos(hWnd));
	propdat.nMidiDelay = uPos * 10;

	/* MIDIxTEhobt@ƈv */
	if (IsDlgButtonChecked(hDlg, IDC_POP_MIDIDLYSB) == BST_CHECKED) {
		propdat.bMidiDelayMode = TRUE;
	}
	else {
		propdat.bMidiDelayMode = FALSE;
	}
#endif

#ifdef RSC
	/* RS-232Cgp */
	if (IsDlgButtonChecked(hDlg, IDC_POP_COMENABLE) == BST_CHECKED) {
		propdat.bCommPortEnable = TRUE;
	}
	else {
		propdat.bCommPortEnable = FALSE;
	}

	/* RS-232C{[[g */
	hWnd = GetDlgItem(hDlg, IDC_POP_COMBPSC);
	propdat.uCommPortBps = (BYTE)ComboBox_GetCurSel(hWnd);

	/* RS-232C|[g */
	hWnd = GetDlgItem(hDlg, IDC_POP_COMPORTC);
	propdat.nCommPortNo = ComboBox_GetCurSel(hWnd) + 1;
#endif
}

/*
 *	|[gy[W
 *	_CAOvV[W
 */
static BOOL CALLBACK PortPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			PortPageInit(hDlg);
			return TRUE;

#ifdef MIDI
		/* R}h */
		case WM_COMMAND:
			PortPageCmd(hDlg, LOWORD(wParam), HIWORD(wParam), (HWND)lParam);
			return TRUE;
#endif

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				PortPageApply(hDlg);
				return TRUE;
			}
			break;

#ifdef MIDI
		/* XN[ */
		case WM_VSCROLL:
			PortPageVScroll(hDlg, HIWORD(wParam), (HWND)lParam);
			break;
#endif

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_POP_HELP);
			}
			break;
	}

	return FALSE;
}

#endif	/* RSC/MIDI */

/*-[ v^y[W ]--------------------------------------------------------*/

#ifdef LPRINT

/*
 *	v^y[W
 *	_CAO
 */
static void FASTCALL LprPageInit(HWND hDlg)
{
#ifndef JASTSOUND
HWND hWnd;
#endif

	/* V[g */
	ASSERT(hDlg);
	SheetInit(hDlg);

	/* v^G~[V[h */
	switch (propdat.uPrinterEnable) {
		case LP_EMULATION:
			CheckDlgButton(hDlg, IDC_LPP_LPREMUENABLE, BST_CHECKED);
			break;
		case LP_LOG:
			CheckDlgButton(hDlg, IDC_LPP_LPRLOGENABLE, BST_CHECKED);
			break;
#ifdef JASTSOUND
		case LP_JASTSOUND:
			CheckDlgButton(hDlg, IDC_LPP_LPRJASTSOUNDENABLE, BST_CHECKED);
			break;
#endif
		case LP_DISABLE:
			CheckDlgButton(hDlg, IDC_LPP_LPRDISABLE, BST_CHECKED);
			break;
		default:
			ASSERT(FALSE);
	}

#ifndef JASTSOUND
	hWnd = GetDlgItem(hDlg, IDC_LPP_LPRJASTSOUNDENABLE);
	EnableWindow(hWnd, FALSE);
#endif

	/* OS̃tHg𗘗p */
	if (propdat.bLprUseOsFont) {
		CheckDlgButton(hDlg, IDC_LPP_LPROSFNT, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_LPP_LPROSFNT, BST_UNCHECKED);
	}

	/* o͂ */
	if (propdat.bLprOutputKanji) {
		CheckDlgButton(hDlg, IDC_LPP_LPRKANJI, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_LPP_LPRKANJI, BST_UNCHECKED);
	}

	/* v^Oo̓pX */
	SetWindowText(GetDlgItem(hDlg, IDC_LPP_LPRLOGPATHNAME),
		propdat.szLprLogPath);
}

/*
 *	v^y[W
 *	R}h
 */
static void FASTCALL LprPageCmd(HWND hDlg, WORD wID, WORD wNotifyCode, HWND hWnd)
{
	char tmp[MAX_PATH + 1];
	char path[256 + 1];

	ASSERT(hDlg);
	UNUSED(wNotifyCode);
	UNUSED(hWnd);

	/* ID */
	switch (wID) {
		/* v^Oo̓pX */
		case IDC_LPP_LPRLOGDIALOG:
			if (!FileSelectSub(FALSE, IDS_LPRFILTER, tmp, NULL, 
				LPT_LOG_FILE_DIR)) {
				return;
			}
			_snprintf(path, sizeof(path), tmp);
			SetWindowText(GetDlgItem(hDlg, IDC_LPP_LPRLOGPATHNAME), path);
			break;
	}
}

/*
 *	v^y[W
 *	Kp
 */
static void FASTCALL LprPageApply(HWND hDlg)
{
	ASSERT(hDlg);

	/* Xe[gύX */
	uPropertyState = 2;

	/* v^gp */
	if (IsDlgButtonChecked(hDlg, IDC_LPP_LPREMUENABLE) == BST_CHECKED) {
		propdat.uPrinterEnable = LP_EMULATION;
	}
	else if (IsDlgButtonChecked(hDlg, IDC_LPP_LPRLOGENABLE) == BST_CHECKED) {
		propdat.uPrinterEnable = LP_LOG;
	}
#ifdef JASTSOUND
	else if (IsDlgButtonChecked(hDlg, IDC_LPP_LPRJASTSOUNDENABLE) == BST_CHECKED) {
		propdat.uPrinterEnable = LP_JASTSOUND;
	}
#endif
	else {
		propdat.uPrinterEnable = LP_DISABLE;
	}

	/* OS̃tHg𗘗p */
	if (IsDlgButtonChecked(hDlg, IDC_LPP_LPROSFNT) == BST_CHECKED) {
		propdat.bLprUseOsFont = TRUE;
	}
	else {
		propdat.bLprUseOsFont = FALSE;
	}

	/* o͂ */
	if (IsDlgButtonChecked(hDlg, IDC_LPP_LPRKANJI) == BST_CHECKED) {
		propdat.bLprOutputKanji = TRUE;
	}
	else {
		propdat.bLprOutputKanji = FALSE;
	}

	/* v^Oo̓pX */
	GetWindowText(GetDlgItem(hDlg, IDC_LPP_LPRLOGPATHNAME),
		propdat.szLprLogPath, 256);
}

/*
 *	v^y[W
 *	_CAOvV[W
 */
static BOOL CALLBACK LprPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	UNUSED(wParam);

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			LprPageInit(hDlg);
			return TRUE;

		/* R}h */
		case WM_COMMAND:
			LprPageCmd(hDlg, LOWORD(wParam), HIWORD(wParam), (HWND)lParam);
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				LprPageApply(hDlg);
				return TRUE;
			}
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_LPP_HELP);
			}
			break;
	}

	return FALSE;
}

#endif /* LPRINT */

/*-[ IvVy[W ]-----------------------------------------------------*/

/*
 *	IvVy[W
 *	_CAO
 */
static void FASTCALL OptPageInit(HWND hDlg)
{
	HWND hWnd;
#if (XM7_VER == 1 && defined(L4CARD)) || defined(MOUSE)
#ifdef MOUSE
	char string[128];
#endif
#endif

	/* V[g */
	ASSERT(hDlg);
	SheetInit(hDlg);

	/* OPN */
	if (propdat.bOPNEnable) {
		CheckDlgButton(hDlg, IDC_OP_OPNB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_OPNB, BST_UNCHECKED);
	}

	/* WHG */
	if (propdat.bWHGEnable) {
		CheckDlgButton(hDlg, IDC_OP_WHGB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_WHGB, BST_UNCHECKED);
	}

	/* THG */
	if (propdat.bTHGEnable) {
		CheckDlgButton(hDlg, IDC_OP_THGB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_THGB, BST_UNCHECKED);
	}

#if XM7_VER >= 2
	/* rfIfBW^CY */
	if (propdat.bDigitizeEnable) {
		CheckDlgButton(hDlg, IDC_OP_DIGITIZEB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_DIGITIZEB, BST_UNCHECKED);
	}
#endif

#if XM7_VER >= 2
	/* {J[h */
	if (propdat.bJCardEnable) {
		CheckDlgButton(hDlg, IDC_OP_JCARDB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_JCARDB, BST_UNCHECKED);
	}
#if XM7_VER == 2
	if (!jcard_available) {
		hWnd = GetDlgItem(hDlg, IDC_OP_JCARDB);
		EnableWindow(hWnd, FALSE);
	}
#endif
#endif

#if ((XM7_VER >= 3) || (XM7_VER == 2 && defined(FMTV151)))
	/* gRAM/FMTV-151 */
	if (propdat.bExtRAMEnable) {
		CheckDlgButton(hDlg, IDC_OP_RAMB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_RAMB, BST_UNCHECKED);
	}
#endif

#if XM7_VER == 1
#ifdef L4CARD
	/* 400CJ[h */
	if (detect_400linecard && propdat.b400LineCardEnable) {
		CheckDlgButton(hDlg, IDC_OP_400LINEB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_400LINEB, BST_UNCHECKED);
	}
	if (!detect_400linecard) {
		hWnd = GetDlgItem(hDlg, IDC_OP_400LINEB);
		EnableWindow(hWnd, FALSE);
	}
#endif

#ifdef JSUB
	/* {TuVXe */
	if (propdat.bJSubEnable) {
		CheckDlgButton(hDlg, IDC_OP_JSUBB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_JSUBB, BST_UNCHECKED);
	}
	if (!jsub_available) {
		hWnd = GetDlgItem(hDlg, IDC_OP_JSUBB);
		EnableWindow(hWnd, FALSE);
	}
#endif

#ifdef BUBBLE
	/* ou */
	if (propdat.bBubbleEnable) {
		CheckDlgButton(hDlg, IDC_OP_BMCB, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_BMCB, BST_UNCHECKED);
	}
#endif
#endif

#ifdef MOUSE
	/* }EXG~[V */
	if (propdat.bMouseCapture) {
		CheckDlgButton(hDlg, IDC_OP_MOUSEEM, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_MOUSEEM, BST_UNCHECKED);
	}

	/* }EXڑ|[g */
	if (propdat.nMousePort == 1) {
		CheckDlgButton(hDlg, IDC_OP_MOUSE_PORT1, BST_CHECKED);
	}
	else if (propdat.nMousePort == 2) {
		CheckDlgButton(hDlg, IDC_OP_MOUSE_PORT2, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_OP_MOUSE_FMMOUSE, BST_CHECKED);
	}

	/* }EX[h؂ւ */
	hWnd = GetDlgItem(hDlg, IDC_OP_MOUSESWC);
	ASSERT(hWnd);
	string[0] = '\0';
	(void)ComboBox_ResetContent(hWnd);
	LoadString(hAppInstance, IDS_OP_MOUSESW_1, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_OP_MOUSESW_2, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_OP_MOUSESW_3, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	(void)ComboBox_SetCurSel(hWnd, propdat.uMidBtnMode);
#endif
}

/*
 *	IvVy[W
 *	Kp
 */
static void FASTCALL OptPageApply(HWND hDlg)
{
#ifdef MOUSE
	HWND hWnd;
#endif

	ASSERT(hDlg);

	/* Xe[gύX */
	uPropertyState = 2;

	/* OPN */
	if (IsDlgButtonChecked(hDlg, IDC_OP_OPNB) == BST_CHECKED) {
		propdat.bOPNEnable = TRUE;
	}
	else {
		propdat.bOPNEnable = FALSE;
	}

	/* WHG */
	if (IsDlgButtonChecked(hDlg, IDC_OP_WHGB) == BST_CHECKED) {
		propdat.bWHGEnable = TRUE;
	}
	else {
		propdat.bWHGEnable = FALSE;
	}

	/* THG */
	if (IsDlgButtonChecked(hDlg, IDC_OP_THGB) == BST_CHECKED) {
		propdat.bTHGEnable = TRUE;
	}
	else {
		propdat.bTHGEnable = FALSE;
	}

#if XM7_VER >= 2
	/* rfIfBW^CY */
	if (IsDlgButtonChecked(hDlg, IDC_OP_DIGITIZEB) == BST_CHECKED) {
		propdat.bDigitizeEnable = TRUE;
	}
	else {
		propdat.bDigitizeEnable = FALSE;
	}
#endif

#if XM7_VER >= 2
	/* {J[h */
	if (IsDlgButtonChecked(hDlg, IDC_OP_JCARDB) == BST_CHECKED) {
		propdat.bJCardEnable = TRUE;
	}
	else {
		propdat.bJCardEnable = FALSE;
	}
#endif

#if ((XM7_VER >= 3) || (XM7_VER == 2 && defined(FMTV151)))
	/* gRAM/FMTV-151 */
	if (IsDlgButtonChecked(hDlg, IDC_OP_RAMB) == BST_CHECKED) {
		propdat.bExtRAMEnable = TRUE;
	}
	else {
		propdat.bExtRAMEnable = FALSE;
	}
#endif

#if XM7_VER == 1
#ifdef L4CARD
	/* 400CJ[h */
	if (IsDlgButtonChecked(hDlg, IDC_OP_400LINEB) == BST_CHECKED) {
		propdat.b400LineCardEnable = TRUE;
	}
	else {
		propdat.b400LineCardEnable = FALSE;
	}
#endif

#ifdef JSUB
	/* {TuVXe */
	if (IsDlgButtonChecked(hDlg, IDC_OP_JSUBB) == BST_CHECKED) {
		propdat.bJSubEnable = TRUE;
	}
	else {
		propdat.bJSubEnable = FALSE;
	}
#endif

#ifdef BUBBLE
	/* ou */
	if (IsDlgButtonChecked(hDlg, IDC_OP_BMCB) == BST_CHECKED) {
		propdat.bBubbleEnable = TRUE;
	}
	else {
		propdat.bBubbleEnable = FALSE;
	}
#endif
#endif

#ifdef MOUSE
	/* }EXG~[V */
	if (IsDlgButtonChecked(hDlg, IDC_OP_MOUSEEM) == BST_CHECKED) {
		propdat.bMouseCapture = TRUE;
	}
	else {
		propdat.bMouseCapture = FALSE;
	}

	/* }EXڑ|[g */
	if (IsDlgButtonChecked(hDlg, IDC_OP_MOUSE_PORT1) == BST_CHECKED) {
		propdat.nMousePort = 1;
	}
	else if (IsDlgButtonChecked(hDlg, IDC_OP_MOUSE_PORT2) == BST_CHECKED) {
		propdat.nMousePort = 2;
	}
	else {
		propdat.nMousePort = 3;
	}

	/* }EX[h؂ւ */
	hWnd = GetDlgItem(hDlg, IDC_OP_MOUSESWC);
	propdat.uMidBtnMode = (BYTE)ComboBox_GetCurSel(hWnd);
#endif
}

/*
 *	IvVy[W
 *	_CAOvV[W
 */
static BOOL CALLBACK OptPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	UNUSED(wParam);

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			OptPageInit(hDlg);
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				OptPageApply(hDlg);
				return TRUE;
			}
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_OP_HELP);
			}
			break;
	}

	return FALSE;
}

/*-[ y[W ]-----------------------------------------------------------*/

#if XM7_VER == 1/*
 *	y[W
 *	_CAO
 */
static void FASTCALL AltPageInit(HWND hDlg)
{
#if XM7_VER == 1
	char string[256];
	HWND hWnd;
#endif

	/* V[g */
	ASSERT(hDlg);
	SheetInit(hDlg);

	/* FM-8 PSG */
	if (propdat.bPSGEnable) {
		CheckDlgButton(hDlg, IDC_AP_PSG, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_AP_PSG, BST_UNCHECKED);
	}

	/* FM-8 oN؂芷 */
	hWnd = GetDlgItem(hDlg, IDC_AP_BANKSELB);
	ASSERT(hWnd);
	string[0] = '\0';
	(void)ComboBox_ResetContent(hWnd);
	LoadString(hAppInstance, IDS_AP_BANKSEL_OFF, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_AP_BANKSEL_ON, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_AP_BANKSEL_ON_DIPSW, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	LoadString(hAppInstance, IDS_AP_BANKSEL_RAMFILE, string, sizeof(string));
	(void)ComboBox_AddString(hWnd, string);
	(void)ComboBox_SetCurSel(hWnd, configdat.uBankSelectEnable);

	/* FM-8 TuVXeύX */
	if (propdat.bSubSystemRomXchg) {
		CheckDlgButton(hDlg, IDC_AP_SUBSYS, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_AP_SUBSYS, BST_UNCHECKED);
	}
	if (!available_fm7roms) {
		hWnd = GetDlgItem(hDlg, IDC_AP_SUBSYS);
		EnableWindow(hWnd, FALSE);
	}

	/* FM-8 L[̓[hFM-7݊ */
	if (propdat.bKeyModeFlag) {
		CheckDlgButton(hDlg, IDC_AP_KEY, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_AP_KEY, BST_UNCHECKED);
	}
	if (!available_fm7roms) {
		hWnd = GetDlgItem(hDlg, IDC_AP_KEY);
		EnableWindow(hWnd, FALSE);
	}

	/* FM-8 e[v[^CPUxtO */
	if (propdat.bMotorOnLowSpeed) {
		CheckDlgButton(hDlg, IDC_AP_TAPECPUSPEED, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_AP_TAPECPUSPEED, BST_UNCHECKED);
	}

	/* FM-8 CL[I/OCl[utO */
	if (propdat.bKeyIOPort) {
		CheckDlgButton(hDlg, IDC_AP_KEYIOPORT, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_AP_KEYIOPORT, BST_UNCHECKED);
	}

	/* FM-8 TTLpbgCl[utO */
	if (propdat.bTTLPalet) {
		CheckDlgButton(hDlg, IDC_AP_TTLPALET, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_AP_TTLPALET, BST_UNCHECKED);
	}

	/* FM-8 FM-7݊CIRQCl[utO */
	if (propdat.bFM7IRQ) {
		CheckDlgButton(hDlg, IDC_AP_FM7IRQ, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_AP_FM7IRQ, BST_UNCHECKED);
	}
}

/*
 *	y[W
 *	Kp
 */
static void FASTCALL AltPageApply(HWND hDlg)
{
	ASSERT(hDlg);

	/* Xe[gύX */
	uPropertyState = 2;

	/* FM-8 PSG */
	if (IsDlgButtonChecked(hDlg, IDC_AP_PSG) == BST_CHECKED) {
		propdat.bPSGEnable = TRUE;
	}
	else {
		propdat.bPSGEnable = FALSE;
	}

	/* FM-8 oN؂芷 */
	/* oN؂芷Cl[u */
	propdat.uBankSelectEnable =
		ComboBox_GetCurSel(GetDlgItem(hDlg, IDC_AP_BANKSELB));

	/* FM-8 TuVXeύX */
	if (IsDlgButtonChecked(hDlg, IDC_AP_SUBSYS) == BST_CHECKED) {
		propdat.bSubSystemRomXchg = TRUE;
	}
	else {
		propdat.bSubSystemRomXchg = FALSE;
	}

	/* FM-8 L[̓[hFM-7݊ */
	if (IsDlgButtonChecked(hDlg, IDC_AP_KEY) == BST_CHECKED) {
		propdat.bKeyModeFlag = TRUE;
	}
	else {
		propdat.bKeyModeFlag = FALSE;
	}

	/* FM-8 e[v[^CPUxtO */
	if (IsDlgButtonChecked(hDlg, IDC_AP_TAPECPUSPEED) == BST_CHECKED) {
		propdat.bMotorOnLowSpeed = TRUE;
	}
	else {
		propdat.bMotorOnLowSpeed = FALSE;
	}

	/* FM-8 CL[I/OCl[utO */
	if (IsDlgButtonChecked(hDlg, IDC_AP_KEYIOPORT) == BST_CHECKED) {
		propdat.bKeyIOPort = TRUE;
	}
	else {
		propdat.bKeyIOPort = FALSE;
	}

	/* FM-8 TTLpbgCl[utO */
	if (IsDlgButtonChecked(hDlg, IDC_AP_TTLPALET) == BST_CHECKED) {
		propdat.bTTLPalet = TRUE;
	}
	else {
		propdat.bTTLPalet = FALSE;
	}

	/* FM-8 FM-7݊CIRQCl[utO */
	if (IsDlgButtonChecked(hDlg, IDC_AP_FM7IRQ) == BST_CHECKED) {
		propdat.bFM7IRQ = TRUE;
	}
	else {
		propdat.bFM7IRQ = FALSE;
	}
}

/*
 *	y[W
 *	_CAOvV[W
 */
static BOOL CALLBACK AltPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	UNUSED(wParam);

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			AltPageInit(hDlg);
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			/* y[WI */
			if (pnmh->code == PSN_APPLY) {
				AltPageApply(hDlg);
				return TRUE;
			}
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_AP_HELP);
			}
			break;
	}

	return FALSE;
}
#endif

/*-[ GUIȆy[W ]----------------------------------------------------*/

/*
 *	GUIȆy[W
 *	_CAO
 */
static void FASTCALL EtcPageInit(HWND hDlg)
{
	/* V[g */
	ASSERT(hDlg);
	SheetInit(hDlg);

	/* MAGUS΍􏈗 */
	if (propdat.bMagusPatch) {
		CheckDlgButton(hDlg, IDC_EP_MAGUSPATCH, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_EP_MAGUSPATCH, BST_UNCHECKED);
	}

	/* FM-7[hRAMύX */
	if (propdat.bRomRamWrite) {
		CheckDlgButton(hDlg, IDC_EP_ROMRAMWRITE, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_EP_ROMRAMWRITE, BST_UNCHECKED);
	}

	/* TuEChẼ|bvAbv */
	if (propdat.bPopupSwnd) {
		CheckDlgButton(hDlg, IDC_EP_POPUPSWND, BST_CHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_EP_POPUPSWND, BST_UNCHECKED);
	}

	/* t@CI_CAÕZ^O */
	if (propdat.bOFNCentering) {
		CheckDlgButton(hDlg, IDC_EP_OFNCENTERING, BST_UNCHECKED);
	}
	else {
		CheckDlgButton(hDlg, IDC_EP_OFNCENTERING, BST_CHECKED);
	}

}

/*
 *	GUIȆy[W
 *	Kp
 */
static void FASTCALL EtcPageApply(HWND hDlg)
{
	ASSERT(hDlg);

	/* Xe[gύX */
	uPropertyState = 2;

	/* MAGUS΍􏈗 */
	if (IsDlgButtonChecked(hDlg, IDC_EP_MAGUSPATCH) == BST_CHECKED) {
		propdat.bMagusPatch = TRUE;
	}
	else {
		propdat.bMagusPatch = FALSE;
	}

	/* FM-7[hRAMύX */
	if (IsDlgButtonChecked(hDlg, IDC_EP_ROMRAMWRITE) == BST_CHECKED) {
		propdat.bRomRamWrite = TRUE;
	}
	else {
		propdat.bRomRamWrite = FALSE;
	}

	/* TuEChẼ|bvAbv */
	if (IsDlgButtonChecked(hDlg, IDC_EP_POPUPSWND) == BST_CHECKED) {
		propdat.bPopupSwnd = TRUE;
	}
	else {
		propdat.bPopupSwnd = FALSE;
	}

	/* t@CI_CAÕZ^O */
	if (IsDlgButtonChecked(hDlg, IDC_EP_OFNCENTERING) == BST_CHECKED) {
		propdat.bOFNCentering = FALSE;
	}
	else {
		propdat.bOFNCentering = TRUE;
	}
}

/*
 *	GUIȆy[W
 *	_CAOvV[W
 */
static BOOL CALLBACK EtcPageProc(HWND hDlg, UINT msg,
									 WPARAM wParam, LPARAM lParam)
{
	LPNMHDR pnmh;

	UNUSED(wParam);

	switch (msg) {
		/*  */
		case WM_INITDIALOG:
			EtcPageInit(hDlg);
			return TRUE;

		/* ʒm */
		case WM_NOTIFY:
			pnmh = (LPNMHDR)lParam;
			if (pnmh->code == PSN_APPLY) {
				EtcPageApply(hDlg);
				return TRUE;
			}
			break;

		/* J[\ݒ */
		case WM_SETCURSOR:
			if (HIWORD(lParam) == WM_MOUSEMOVE) {
				PageHelp(hDlg, IDC_EP_HELP);
			}
			break;
	}

	return FALSE;
}

/*-[ vpeBV[g ]-----------------------------------------------------*/

/*
 *	vpeBV[g
 *	y[W쐬
 */
static HPROPSHEETPAGE FASTCALL PageCreate(UINT TemplateID,
			BOOL (CALLBACK *DlgProc)(HWND, UINT, WPARAM, LPARAM))
{
	PROPSHEETPAGE psp;

	/* \̂쐬 */
	memset(&psp, 0, sizeof(PROPSHEETPAGE));
	psp.dwSize = PROPSHEETPAGE_V1_SIZE;
	psp.dwFlags = 0;
	psp.hInstance = hAppInstance;
	psp.u.pszTemplate = MAKEINTRESOURCE(TemplateID);
	psp.pfnDlgProc = (DLGPROC)DlgProc;

	return CreatePropertySheetPage(&psp);
}

/*
 *	vpeBV[g
 *	
 */
static void FASTCALL SheetInit(HWND hDlg)
{
	RECT drect;
	RECT prect;
	LONG lStyleEx;
	HWND hWnd;

	/* tO`FbNAV[gς݂ɐݒ */
	if (uPropertyState > 0) {
		return;
	}
	uPropertyState = 1;

	/* vpeBV[gwv{^ */
	lStyleEx = GetWindowLong(GetParent(hDlg), GWL_EXSTYLE);
	lStyleEx &= ~WS_EX_CONTEXTHELP;
	SetWindowLong(GetParent(hDlg), GWL_EXSTYLE, lStyleEx);

	/* ^u̕s\ */
	hWnd = PropSheet_GetTabControl(GetParent(hDlg));
	lStyleEx = GetWindowLong(hWnd, GWL_STYLE);
	lStyleEx &= ~TCS_SINGLELINE;
	lStyleEx |= TCS_MULTILINE;
	SetWindowLong(hWnd, GWL_STYLE, lStyleEx);

	/* vpeBV[gACEChE̒Ɋ񂹂 */
	GetWindowRect(hMainWnd, &prect);
	GetWindowRect(GetParent(hDlg), &drect);
	drect.right -= drect.left;
	drect.bottom -= drect.top;
	drect.left = (prect.right - prect.left) / 2 + prect.left;
	drect.left -= (drect.right / 2);
	drect.top = (prect.bottom - prect.top) / 2 + prect.top;
	drect.top -= (drect.bottom / 2);
	MoveWindow(GetParent(hDlg), drect.left, drect.top, drect.right, drect.bottom, FALSE);

}

/*
 *	ݒ(C)
 */
void FASTCALL OnConfig(HWND hWnd)
{
	PROPSHEETHEADER pshead;
	HPROPSHEETPAGE hpspage[16];
	int i;
	int ver;
	int page;

	ASSERT(hWnd);

	/* f[^] */
	propdat = configdat;

	/* vpeBy[W쐬 */
	page = 0;
	hpspage[page++] = PageCreate(IDD_GENERALPAGE, GeneralPageProc);
	hpspage[page++] = PageCreate(IDD_SOUNDPAGE, SoundPageProc);
	hpspage[page++] = PageCreate(IDD_VOLUMEPAGE, VolumePageProc);
	hpspage[page++] = PageCreate(IDD_KBDPAGE, KbdPageProc);
	hpspage[page++] = PageCreate(IDD_JOYPAGE, JoyPageProc);
	hpspage[page++] = PageCreate(IDD_SCRPAGE, ScrPageProc);
#if defined(RSC) || defined(MIDI)
	hpspage[page++] = PageCreate(IDD_PORTPAGE, PortPageProc);
#endif
#ifdef LPRINT
	hpspage[page++] = PageCreate(IDD_LPRPAGE, LprPageProc);
#endif
	hpspage[page++] = PageCreate(IDD_OPTPAGE, OptPageProc);
#if XM7_VER == 1
	hpspage[page++] = PageCreate(IDD_ALTERPAGE, AltPageProc);
#endif
	hpspage[page++] = PageCreate(IDD_ETCPAGE, EtcPageProc);

	/* vpeBy[W`FbN */
	for (i=0; i<page; i++) {
		if (!hpspage[i]) {
			return;
		}
	}

	/* vpeBV[g쐬 */
	memset(&pshead, 0, sizeof(pshead));
	pshead.dwSize = PROPSHEETHEADER_V1_SIZE;
	pshead.dwFlags = PSH_NOAPPLYNOW;
	pshead.hwndParent = hWnd;
	pshead.hInstance = hAppInstance;
	pshead.pszCaption = MAKEINTRESOURCE(IDS_CONFIGCAPTION);
	pshead.nPages = page;
	pshead.u2.nStartPage = 0;
	pshead.u3.phpage = hpspage;

	/* vpeBV[gs */
	uPropertyState = 0;
	uPropertyHelp = 0;
	PropertySheet(&pshead);

	/* ʂokȊOȂI */
	if (uPropertyState != 2) {
		return;
	}

	/* okȂ̂ŁAf[^] */
	configdat = propdat;

	/* Kp */
	LockVM();
#if XM7_VER >= 2
	ver = fm7_ver;
#else
	ver = fm_subtype;
#endif
	ApplyCfg();

	/* @ύX𔺂ꍇAZbg */
#if XM7_VER == 1 && defined(BUBBLE)
	if ((fm_subtype != FMSUB_FM8) && (boot_mode == BOOT_BUBBLE)) {
		boot_mode = BOOT_DOS;
		GetCfg();
	}
#endif

#if XM7_VER >= 2
	if (ver != fm7_ver) {
#else
	if (ver != fm_subtype) {
#endif
		/* Zbg */
		system_reset();
		SetAllMRUFile();
		if (hMainWnd) {
			OnRefresh(hMainWnd);
		}
	}

	UnlockVM();
}
#endif	/* _WIN32 */
